/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.bit.parameter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.ctakes.gui.pipeline.bit.parameter.ParameterHolder;
import org.apache.log4j.Logger;

public class ParameterInfoPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger((String)"ParameterInfoPanel");
    private JLabel _name = new JLabel();
    private JLabel _type;
    private JLabel _description;
    private JLabel _mandatory;
    protected JComponent _values;
    private ParameterHolder _holder;

    public ParameterInfoPanel() {
        super(new GridLayout(5, 1));
        JComponent namePanel = this.createNamePanel("Parameter Name:", this._name);
        this._type = new JLabel();
        JComponent typePanel = this.createNamePanel("Parameter Type:", this._type);
        this._description = new JLabel();
        JComponent descPanel = this.createNamePanel("Description:", this._description);
        this._mandatory = new JLabel();
        JComponent mandatoryPanel = this.createNamePanel("Mandatory:", this._mandatory);
        this._values = this.createValuesEditor();
        JComponent valuesPanel = this.createNamePanel(this.getValueLabelPrefix() + " Values:", this._values);
        this.add(namePanel);
        this.add(typePanel);
        this.add(descPanel);
        this.add(mandatoryPanel);
        this.add(valuesPanel);
    }

    protected String getValueLabelPrefix() {
        return "Default";
    }

    protected JComponent createValuesEditor() {
        return new JLabel();
    }

    protected void setParameterValues(String values) {
        ((JLabel)this._values).setText(values);
    }

    private JComponent createNamePanel(String name, JComponent namedLabel) {
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(new EmptyBorder(2, 10, 2, 10));
        JLabel label = new JLabel(name);
        label.setPreferredSize(new Dimension(90, 20));
        label.setHorizontalAlignment(11);
        EmptyBorder emptyBorder = new EmptyBorder(0, 10, 0, 0);
        CompoundBorder border = new CompoundBorder(UIManager.getLookAndFeelDefaults().getBorder("TextField.border"), emptyBorder);
        namedLabel.setBorder(border);
        panel.add((Component)label, "West");
        panel.add((Component)namedLabel, "Center");
        return panel;
    }

    private void clear() {
        this.clear(this._name);
        this.clear(this._type);
        this.clear(this._description);
        this.clear(this._mandatory);
        this.setParameterValues("");
    }

    private void clear(JLabel label) {
        this.setLabelText(label, "");
    }

    private void setLabelText(JLabel label, String text) {
        this.setLabelText(label, text, text);
    }

    private void setLabelText(JLabel label, String text, String toolTip) {
        label.setText(text);
        label.setToolTipText(toolTip);
    }

    public void setParameterHolder(ParameterHolder holder) {
        this._holder = holder;
        this.clear();
    }

    private void setParameterIndex(int index) {
        if (index < 0 || this._holder == null) {
            this.clear();
            return;
        }
        this.setLabelText(this._name, this._holder.getParameterName(index));
        this.setLabelText(this._type, this._holder.getParameterClass(index));
        this.setLabelText(this._description, this._holder.getParameterDescription(index));
        boolean mandatory = this._holder.isParameterMandatory(index);
        this.setLabelText(this._mandatory, Boolean.toString(mandatory), "A parameter Value is " + (mandatory ? "" : "not ") + "mandatory for the Pipe Bit to operate.");
        String values = Arrays.stream(this._holder.getParameterValue(index)).filter(v -> !"org.apache.uima.fit.descriptor.ConfigurationParameter.NO_DEFAULT_VALUE".equals(v)).collect(Collectors.joining(" , "));
        this.setParameterValues(values);
    }

    public void setParameterTable(JTable parameterTable) {
        ListSelectionModel selectionModel = parameterTable.getSelectionModel();
        selectionModel.addListSelectionListener(new ParameterTableListener(parameterTable));
    }

    private class ParameterTableListener
    implements ListSelectionListener {
        private final JTable __parameterTable;

        private ParameterTableListener(JTable parameterTable) {
            this.__parameterTable = parameterTable;
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            int[] selectedRows = this.__parameterTable.getSelectedRows();
            if (selectedRows.length == 0) {
                ParameterInfoPanel.this.setParameterIndex(-1);
            } else {
                ParameterInfoPanel.this.setParameterIndex(selectedRows[0]);
            }
        }
    }
}

