/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.component;

import java.util.Arrays;
import java.util.Collection;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.spi.LoggingEvent;

public final class LoggerPanel
extends JScrollPane {
    private static final Level[] ALL_LEVELS = new Level[]{Level.FATAL, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE};
    private final Appender _appender;
    private final Document _textAreaDoc = new PlainDocument();

    public static LoggerPanel createLoggerPanel(Level ... levels) {
        LoggerPanel panel = new LoggerPanel(levels);
        LogManager.getRootLogger().addAppender(panel.getLogHandler());
        return panel;
    }

    private LoggerPanel(Level ... levels) {
        JTextArea textArea = new JTextArea(this._textAreaDoc);
        textArea.setEditable(false);
        textArea.setEnabled(false);
        super.setViewportView(textArea);
        this._appender = new LogHandler(levels);
    }

    public String getText() {
        try {
            return this._textAreaDoc.getText(0, this._textAreaDoc.getLength());
        }
        catch (BadLocationException blE) {
            return "";
        }
    }

    public void clearText() {
        SwingUtilities.invokeLater(() -> {
            try {
                this._textAreaDoc.remove(0, this._textAreaDoc.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        });
    }

    public void appendText(String text) {
        SwingUtilities.invokeLater(() -> {
            try {
                this._textAreaDoc.insertString(this._textAreaDoc.getLength(), text, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        });
    }

    private Appender getLogHandler() {
        return this._appender;
    }

    private class LogHandler
    extends AppenderSkeleton {
        private final Collection<Level> _levels;

        private LogHandler(Level ... levels) {
            this._levels = Arrays.asList(levels.length == 0 ? ALL_LEVELS : levels);
        }

        protected void append(LoggingEvent event) {
            if (this._levels.contains(event.getLevel())) {
                LoggerPanel.this.appendText(event.getMessage().toString() + "\n");
            }
        }

        public boolean requiresLayout() {
            return false;
        }

        public void close() {
        }
    }
}

