/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.ae;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.ctakes.core.resource.FileResource;
import org.apache.ctakes.core.resource.JdbcConnectionResource;
import org.apache.ctakes.core.resource.LuceneIndexReaderResource;
import org.apache.ctakes.dictionary.lookup.AbstractBaseDictionary;
import org.apache.ctakes.dictionary.lookup.DictionaryEngine;
import org.apache.ctakes.dictionary.lookup.ae.LookupConsumer;
import org.apache.ctakes.dictionary.lookup.ae.LookupInitializer;
import org.apache.ctakes.dictionary.lookup.ae.LookupSpec;
import org.apache.ctakes.dictionary.lookup.algorithms.LookupAlgorithm;
import org.apache.ctakes.dictionary.lookup.filter.StringPreLookupFilterImpl;
import org.apache.ctakes.dictionary.lookup.jdbc.JdbcDictionaryImpl;
import org.apache.ctakes.dictionary.lookup.lucene.LuceneDictionaryImpl;
import org.apache.ctakes.dictionary.lookup.strtable.StringTable;
import org.apache.ctakes.dictionary.lookup.strtable.StringTableDictionaryImpl;
import org.apache.ctakes.dictionary.lookup.strtable.StringTableFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorContextException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class LookupParseUtilities {
    private static int maxSizeList = Integer.MAX_VALUE;

    public static Set<LookupSpec> parseDescriptor(File descFile, UimaContext aContext, int maxListSize) throws JDOMException, IOException, Exception {
        SAXBuilder saxBuilder = new SAXBuilder();
        Document doc = saxBuilder.build(descFile);
        maxSizeList = maxListSize;
        Map<String, DictionaryEngine> dictMap = LookupParseUtilities.parseDictionaries(aContext, doc.getRootElement().getChild("dictionaries"));
        return LookupParseUtilities.parseLookupBindingXml(aContext, dictMap, doc.getRootElement().getChild("lookupBindings"));
    }

    public static Set<LookupSpec> parseDescriptor(File descFile, UimaContext aContext) throws JDOMException, IOException, Exception {
        SAXBuilder saxBuilder = new SAXBuilder();
        Document doc = saxBuilder.build(descFile);
        Map<String, DictionaryEngine> dictMap = LookupParseUtilities.parseDictionaries(aContext, doc.getRootElement().getChild("dictionaries"));
        return LookupParseUtilities.parseLookupBindingXml(aContext, dictMap, doc.getRootElement().getChild("lookupBindings"));
    }

    private static Map<String, DictionaryEngine> parseDictionaries(UimaContext aContext, Element dictetteersEl) throws AnnotatorContextException, Exception {
        HashMap<String, DictionaryEngine> m = new HashMap<String, DictionaryEngine>();
        for (Element dictEl : dictetteersEl.getChildren()) {
            String id = dictEl.getAttributeValue("id");
            DictionaryEngine dictEngine = LookupParseUtilities.parseDictionaryXml(aContext, dictEl);
            m.put(id, dictEngine);
        }
        return m;
    }

    private static DictionaryEngine parseDictionaryXml(UimaContext annotCtx, Element rootDictEl) throws AnnotatorContextException, Exception {
        AbstractBaseDictionary dict;
        String extResrcKey = rootDictEl.getAttributeValue("externalResourceKey");
        Boolean keepCase = new Boolean(rootDictEl.getAttributeValue("caseSensitive"));
        Object extResrc = annotCtx.getResourceObject(extResrcKey);
        if (extResrc == null) {
            throw new Exception("Unable to find external resource with key:" + extResrcKey);
        }
        Element lookupFieldEl = rootDictEl.getChild("lookupField");
        String lookupFieldName = lookupFieldEl.getAttributeValue("fieldName");
        Element implEl = (Element)rootDictEl.getChild("implementation").getChildren().get(0);
        String implType = implEl.getName();
        if (implType.equals("luceneImpl")) {
            if (!(extResrc instanceof LuceneIndexReaderResource)) {
                throw new Exception("Expected external resource to be:" + LuceneIndexReaderResource.class);
            }
            IndexReader indexReader = ((LuceneIndexReaderResource)extResrc).getIndexReader();
            IndexSearcher indexSearcher = new IndexSearcher(indexReader);
            dict = new LuceneDictionaryImpl(indexSearcher, lookupFieldName, maxSizeList);
        } else if (implType.equals("jdbcImpl")) {
            String tableName = implEl.getAttributeValue("tableName");
            if (!(extResrc instanceof JdbcConnectionResource)) {
                throw new Exception("Expected external resource to be:" + JdbcConnectionResource.class);
            }
            Connection conn = ((JdbcConnectionResource)extResrc).getConnection();
            dict = new JdbcDictionaryImpl(conn, tableName, lookupFieldName);
        } else if (implType.equals("csvImpl")) {
            String fieldDelimiter = implEl.getAttributeValue("delimiter");
            if (!(extResrc instanceof FileResource)) {
                throw new Exception("Expected external resource to be:" + FileResource.class);
            }
            String idxFieldNameStr = implEl.getAttributeValue("indexedFieldNames");
            StringTokenizer st = new StringTokenizer(idxFieldNameStr, ",");
            int arrIdx = 0;
            String[] idxFieldNameArr = new String[st.countTokens()];
            while (st.hasMoreTokens()) {
                idxFieldNameArr[arrIdx++] = st.nextToken().trim();
            }
            File csvFile = ((FileResource)extResrc).getFile();
            try (FileReader fr = new FileReader(csvFile);){
                StringTable strTable = StringTableFactory.build((Reader)fr, fieldDelimiter, idxFieldNameArr, true);
                dict = new StringTableDictionaryImpl(strTable, lookupFieldName);
            }
        } else {
            throw new Exception("Unsupported impl type:" + implType);
        }
        for (Element metaFieldEl : rootDictEl.getChild("metaFields").getChildren()) {
            String metaFieldName = metaFieldEl.getAttributeValue("fieldName");
            dict.retainMetaData(metaFieldName);
        }
        DictionaryEngine dictEngine = new DictionaryEngine(dict, keepCase);
        Element excludeList = rootDictEl.getChild("excludeList");
        if (excludeList != null && excludeList.getChildren() != null && excludeList.getChildren().size() > 0) {
            LookupParseUtilities.addExcludeList(dictEngine, excludeList.getChildren().iterator());
        }
        return dictEngine;
    }

    private static void addExcludeList(DictionaryEngine ge, Iterator<?> itr) {
        HashSet<String> hs = new HashSet<String>();
        while (itr.hasNext()) {
            Element item = (Element)itr.next();
            String s = item.getAttributeValue("value");
            System.out.println("Adding exclude value[" + s + "]");
            hs.add(s);
        }
        StringPreLookupFilterImpl plf = new StringPreLookupFilterImpl(hs);
        ge.addPreLookupFilter(plf);
    }

    private static Set<LookupSpec> parseLookupBindingXml(UimaContext annotCtx, Map<String, DictionaryEngine> dictMap, Element lookupBindingsEl) throws Exception {
        HashSet<LookupSpec> lsSet = new HashSet<LookupSpec>();
        for (Element bindingEl : lookupBindingsEl.getChildren()) {
            Element dictEl = bindingEl.getChild("dictionaryRef");
            String dictID = dictEl.getAttributeValue("idRef");
            DictionaryEngine dictEngine = dictMap.get(dictID);
            if (dictEngine == null) {
                throw new Exception("Dictionary undefined: " + dictID);
            }
            Class[] constrArgs = new Class[]{UimaContext.class, Properties.class};
            Object[] constrArgsConsum = new Class[]{UimaContext.class, Properties.class, Integer.TYPE};
            Object[] constrArgsConsumB = new Class[]{UimaContext.class, Properties.class};
            Element lookupInitEl = bindingEl.getChild("lookupInitializer");
            String liClassName = lookupInitEl.getAttributeValue("className");
            Element liPropertiesEl = lookupInitEl.getChild("properties");
            Properties liProps = LookupParseUtilities.parsePropertiesXml(liPropertiesEl);
            Class<?> liClass = Class.forName(liClassName);
            Constructor<?> liConstr = liClass.getConstructor(constrArgs);
            Object[] liArgs = new Object[]{annotCtx, liProps};
            LookupInitializer li = (LookupInitializer)liConstr.newInstance(liArgs);
            Element lookupConsumerEl = bindingEl.getChild("lookupConsumer");
            String lcClassName = lookupConsumerEl.getAttributeValue("className");
            Element lcPropertiesEl = lookupConsumerEl.getChild("properties");
            Properties lcProps = LookupParseUtilities.parsePropertiesXml(lcPropertiesEl);
            Class<?> lcClass = Class.forName(lcClassName);
            Constructor<?>[] consts = lcClass.getConstructors();
            Constructor<?> lcConstr = null;
            Object[] lcArgs = null;
            for (int i = 0; i < consts.length; ++i) {
                lcConstr = consts[i];
                if (Arrays.equals(constrArgsConsum, lcConstr.getParameterTypes())) {
                    lcConstr = lcClass.getConstructor((Class<?>[])constrArgsConsum);
                    lcArgs = new Object[]{annotCtx, lcProps, maxSizeList};
                    continue;
                }
                if (!Arrays.equals(constrArgsConsumB, lcConstr.getParameterTypes())) continue;
                lcConstr = lcClass.getConstructor((Class<?>[])constrArgsConsumB);
                lcArgs = new Object[]{annotCtx, lcProps};
            }
            LookupConsumer lc = (LookupConsumer)lcConstr.newInstance(lcArgs);
            LookupAlgorithm la = li.getLookupAlgorithm(dictEngine);
            LookupSpec ls = new LookupSpec(la, li, lc);
            lsSet.add(ls);
        }
        return lsSet;
    }

    public static int getMaxSizeList() {
        return maxSizeList;
    }

    public static void setMaxSizeList(int maxListSize) {
        maxSizeList = maxListSize;
    }

    private static Properties parsePropertiesXml(Element propsEl) {
        Properties props = new Properties();
        for (Element propEl : propsEl.getChildren()) {
            String key = propEl.getAttributeValue("key");
            String value = propEl.getAttributeValue("value");
            props.put(key, value);
        }
        return props;
    }
}

