/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.pipelines;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.ctakes.constituency.parser.treekernel.TreeExtractor;
import org.apache.ctakes.constituency.parser.util.AnnotationTreeUtils;
import org.apache.ctakes.relationextractor.eval.XMIReader;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.syntax.TopTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.ctakes.utils.tree.SimpleTree;
import org.apache.uima.UIMAException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class TreeFeatureConsumer
extends JCasAnnotator_ImplBase {
    private static final String NO_RELATION_CATEGORY = "-NONE-";
    public static final String PARAM_OUTFILE = "outputFilename";
    public static final String PARAM_CLASSIFY_BOTH_DIRECTIONS = "ClassifyBothDirections";
    private PrintWriter out = null;
    PrintWriter rels = null;
    PrintWriter trees = null;
    int docNum = 0;
    int lineNum = 0;
    @ConfigurationParameter(name="outputFilename", mandatory=true, description="The file of tree examples in svm-light-tk format.")
    private String outputFile;
    protected final boolean classifyBothDirections = false;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        try {
            this.out = new PrintWriter(this.outputFile);
            String relFilename = new File(this.outputFile).getParent() + "/rels.txt";
            this.rels = new PrintWriter(relFilename);
            String treeFilename = new File(this.outputFile).getParent() + "/wholetrees.txt";
            this.trees = new PrintWriter(treeFilename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new ResourceInitializationException();
        }
    }

    public void process(JCas jcas) {
        JCas goldView = null;
        try {
            goldView = jcas.getView("GoldView");
        }
        catch (CASException e) {
            e.printStackTrace();
        }
        HashMap<ArrayList<Annotation>, BinaryTextRelation> relationLookup = new HashMap<ArrayList<Annotation>, BinaryTextRelation>();
        for (BinaryTextRelation relation : JCasUtil.select((JCas)goldView, BinaryTextRelation.class)) {
            Annotation arg2;
            Annotation arg1;
            if (relation.getArg1().getRole().equals("Argument")) {
                arg1 = relation.getArg1().getArgument();
                arg2 = relation.getArg2().getArgument();
            } else {
                arg2 = relation.getArg1().getArgument();
                arg1 = relation.getArg2().getArgument();
            }
            ArrayList<Annotation> key = new ArrayList<Annotation>(Arrays.asList(arg1, arg2));
            relationLookup.put(key, relation);
        }
        for (Sentence sentence : JCasUtil.select((JCas)jcas, Sentence.class)) {
            List args = JCasUtil.selectCovered((JCas)goldView, EntityMention.class, (AnnotationFS)sentence);
            for (int i = 0; i < args.size(); ++i) {
                int jStart;
                EntityMention arg1 = (EntityMention)args.get(i);
                ((Object)((Object)this)).getClass();
                for (int j = jStart = i + 1; j < args.size(); ++j) {
                    String category;
                    BinaryTextRelation relation;
                    EntityMention arg2 = (EntityMention)args.get(j);
                    if (i == j || arg1.getBegin() == arg2.getBegin() && arg1.getEnd() == arg2.getEnd()) continue;
                    ArrayList<EntityMention> key = new ArrayList<EntityMention>(Arrays.asList(arg1, arg2));
                    if (relationLookup.containsKey(key)) {
                        relation = (BinaryTextRelation)relationLookup.get(key);
                        category = relation.getCategory();
                    } else {
                        key = new ArrayList<EntityMention>(Arrays.asList(arg2, arg1));
                        if (relationLookup.containsKey(key)) {
                            relation = (BinaryTextRelation)relationLookup.get(key);
                            category = relation.getCategory() + "-1";
                        } else {
                            category = NO_RELATION_CATEGORY;
                        }
                    }
                    TopTreebankNode root = AnnotationTreeUtils.getTreeCopy((JCas)jcas, (TopTreebankNode)AnnotationTreeUtils.getAnnotationTree((JCas)jcas, (Annotation)arg1));
                    SimpleTree tempClone = TreeExtractor.getSimpleClone((TreebankNode)root);
                    this.trees.println(tempClone.toString());
                    if (root == null) {
                        System.err.println("Root is null!");
                    }
                    TreebankNode t1 = AnnotationTreeUtils.insertAnnotationNode((JCas)jcas, (TopTreebankNode)root, (Annotation)arg1, (String)"ARG1");
                    TreebankNode t2 = AnnotationTreeUtils.insertAnnotationNode((JCas)jcas, (TopTreebankNode)root, (Annotation)arg2, (String)"ARG2");
                    String relationString = category + "(\"" + arg1.getCoveredText() + "\", \"" + arg2.getCoveredText() + "\")";
                    this.rels.print("\t");
                    this.rels.print(this.lineNum);
                    this.rels.print("\t");
                    this.rels.println(relationString);
                    this.rels.flush();
                    ++this.lineNum;
                    SimpleTree tree = null;
                    tree = t1.getBegin() <= t2.getBegin() && t1.getEnd() >= t2.getEnd() ? TreeExtractor.getSimpleClone((TreebankNode)t1) : (t2.getBegin() <= t1.getBegin() && t2.getEnd() >= t1.getEnd() ? TreeExtractor.getSimpleClone((TreebankNode)t2) : TreeExtractor.extractPathEnclosedTree((TreebankNode)t1, (TreebankNode)t2, (JCas)jcas));
                    if (category.equals("location_of-1")) {
                        this.out.print("+1 |BT| ");
                    } else {
                        this.out.print("-1 |BT| ");
                    }
                    TreeExtractor.lowercaseWords((SimpleTree)tree);
                    this.out.print(tree.toString());
                    this.out.println(" |ET|");
                    this.out.flush();
                }
            }
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        this.out.close();
        this.rels.close();
        this.trees.close();
    }

    public static void main(String[] args) {
        File trainDir;
        if (args.length < 2) {
            System.err.println("Usage: TreeFeatureConsumer <training data> <output file>");
            System.exit(-1);
        }
        if (!(trainDir = new File(args[0])).isDirectory()) {
            System.err.println("First arg should be a directory! (full of xmi files)");
            System.exit(-1);
        }
        File[] files = trainDir.listFiles();
        String[] paths = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            paths[i] = files[i].getAbsolutePath();
        }
        try {
            CollectionReader xmiReader = CollectionReaderFactory.createReader(XMIReader.class, (Object[])new Object[]{"files", paths});
            AnalysisEngine treeConsumer = AnalysisEngineFactory.createEngine(TreeFeatureConsumer.class, (Object[])new Object[]{PARAM_OUTFILE, args[1], PARAM_CLASSIFY_BOTH_DIRECTIONS, true});
            SimplePipeline.runPipeline((CollectionReader)xmiReader, (AnalysisEngine[])new AnalysisEngine[]{treeConsumer});
        }
        catch (ResourceInitializationException e) {
            e.printStackTrace();
        }
        catch (UIMAException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

