/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.nn.data;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.ctakes.temporal.duration.Utils;
import org.apache.ctakes.temporal.eval.CommandLine;
import org.apache.ctakes.temporal.eval.THYMEData;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class EventEventAllPairRelPrinter {
    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        File trainFile = options.getTrainOutputDirectory();
        if (trainFile.exists()) {
            trainFile.delete();
        }
        trainFile.createNewFile();
        File devFile = options.getTestOutputDirectory();
        if (devFile.exists()) {
            devFile.delete();
        }
        devFile.createNewFile();
        List<Integer> patientSets = options.getPatients().getList();
        List<Integer> trainItems = THYMEData.getPatientSets(patientSets, THYMEData.TRAIN_REMAINDERS);
        List<Integer> devItems = THYMEData.getPatientSets(patientSets, THYMEData.DEV_REMAINDERS);
        List<File> trainFiles = Utils.getFilesFor(trainItems, options.getInputDirectory());
        List<File> devFiles = Utils.getFilesFor(devItems, options.getInputDirectory());
        CollectionReader trainCollectionReader = Utils.getCollectionReader(trainFiles);
        AnalysisEngine trainDataWriter = AnalysisEngineFactory.createEngine(RelationSnippetPrinter.class, (Object[])new Object[]{"OutputFile", trainFile.getAbsoluteFile()});
        SimplePipeline.runPipeline((CollectionReader)trainCollectionReader, (AnalysisEngine[])new AnalysisEngine[]{trainDataWriter});
        CollectionReader devCollectionReader = Utils.getCollectionReader(devFiles);
        AnalysisEngine devDataWriter = AnalysisEngineFactory.createEngine(RelationSnippetPrinter.class, (Object[])new Object[]{"OutputFile", devFile.getAbsolutePath()});
        SimplePipeline.runPipeline((CollectionReader)devCollectionReader, (AnalysisEngine[])new AnalysisEngine[]{devDataWriter});
    }

    public static String getTokensBetween(JCas jCas, Sentence sent, Annotation left, String leftType, Annotation right, String rightType, int contextSize) throws AnalysisEngineProcessException {
        ArrayList<String> tokens = new ArrayList<String>();
        for (BaseToken baseToken : JCasUtil.selectPreceding((JCas)jCas, BaseToken.class, (AnnotationFS)left, (int)contextSize)) {
            if (sent.getBegin() > baseToken.getBegin()) continue;
            tokens.add(baseToken.getCoveredText());
        }
        tokens.add("<" + leftType + ">");
        tokens.add(left.getCoveredText());
        tokens.add("</" + leftType + ">");
        for (BaseToken baseToken : JCasUtil.selectBetween((JCas)jCas, BaseToken.class, (AnnotationFS)left, (AnnotationFS)right)) {
            tokens.add(baseToken.getCoveredText());
        }
        tokens.add("<" + rightType + ">");
        tokens.add(right.getCoveredText());
        tokens.add("</" + rightType + ">");
        for (BaseToken baseToken : JCasUtil.selectFollowing((JCas)jCas, BaseToken.class, (AnnotationFS)right, (int)contextSize)) {
            if (baseToken.getEnd() > sent.getEnd()) continue;
            tokens.add(baseToken.getCoveredText());
        }
        return String.join((CharSequence)" ", tokens).replaceAll("[\r\n]", " ");
    }

    public static String convertToString(JCas jCas, BaseToken baseToken) throws AnalysisEngineProcessException {
        JCas goldView;
        try {
            goldView = jCas.getView("GoldView");
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        List events = JCasUtil.selectCovering((JCas)goldView, EventMention.class, (int)baseToken.getBegin(), (int)baseToken.getEnd());
        if (events.size() > 0) {
            return "<e> " + baseToken.getCoveredText() + " </e>";
        }
        return baseToken.getCoveredText();
    }

    public static String getSentenceWithMarkedArgs(JCas jCas, Sentence sent, Annotation arg1, Annotation arg2) {
        ArrayList<String> tokens = new ArrayList<String>();
        for (BaseToken baseToken : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)sent)) {
            if (baseToken.getBegin() == arg1.getBegin() || baseToken.getEnd() == arg1.getEnd()) {
                tokens.add("<e>");
                tokens.add(baseToken.getCoveredText());
                tokens.add("</e>");
                continue;
            }
            if (baseToken.getBegin() == arg2.getBegin() || baseToken.getEnd() == arg2.getEnd()) {
                tokens.add("<e>");
                tokens.add(baseToken.getCoveredText());
                tokens.add("</e>");
                continue;
            }
            tokens.add(baseToken.getCoveredText());
        }
        return String.join((CharSequence)" ", tokens).replaceAll("[\r\n]", " ");
    }

    public static class RelationSnippetPrinter
    extends JCasAnnotator_ImplBase {
        @ConfigurationParameter(name="OutputFile", mandatory=true, description="path to the output file")
        private String outputFile;

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            JCas goldView;
            try {
                goldView = jCas.getView("GoldView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            try {
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            HashMap<List<Annotation>, BinaryTextRelation> relationLookup = new HashMap<List<Annotation>, BinaryTextRelation>();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)goldView, BinaryTextRelation.class)) {
                Annotation arg1 = relation.getArg1().getArgument();
                Annotation arg2 = relation.getArg2().getArgument();
                relationLookup.put(Arrays.asList(arg1, arg2), relation);
            }
            for (Sentence sentence : JCasUtil.select((JCas)systemView, Sentence.class)) {
                ArrayList<String> eventEventRelationsInSentence = new ArrayList<String>();
                List eventMentionsInSentence = JCasUtil.selectCovered((JCas)goldView, EventMention.class, (AnnotationFS)sentence);
                for (EventMention mention1 : eventMentionsInSentence) {
                    for (EventMention mention2 : eventMentionsInSentence) {
                        if (mention1 == mention2) continue;
                        BinaryTextRelation relation = (BinaryTextRelation)relationLookup.get(Arrays.asList(mention1, mention2));
                        String label = relation == null ? "none" : relation.getCategory().toLowerCase();
                        String context = mention1.getBegin() < mention2.getBegin() ? EventEventAllPairRelPrinter.getTokensBetween(systemView, sentence, (Annotation)mention1, "arg1", (Annotation)mention2, "arg2", 2) : EventEventAllPairRelPrinter.getTokensBetween(systemView, sentence, (Annotation)mention2, "arg2", (Annotation)mention1, "arg1", 2);
                        String text = String.format("%s|%s", label, context);
                        eventEventRelationsInSentence.add(text.toLowerCase());
                    }
                }
                try {
                    Files.write(Paths.get(this.outputFile, new String[0]), eventEventRelationsInSentence, StandardOpenOption.APPEND);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static interface Options {
        @Option(longName={"xmi-dir"})
        public File getInputDirectory();

        @Option(longName={"patients"})
        public CommandLine.IntegerRanges getPatients();

        @Option(longName={"output-train"})
        public File getTrainOutputDirectory();

        @Option(longName={"output-test"})
        public File getTestOutputDirectory();
    }
}

