/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.eval;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.temporal.ae.ContextualModalityAnnotator;
import org.apache.ctakes.temporal.ae.DocTimeRelAnnotator;
import org.apache.ctakes.temporal.eval.EvaluationOfEventTimeRelations;
import org.apache.ctakes.temporal.eval.Evaluation_ImplBase;
import org.apache.ctakes.temporal.eval.THYMEData;
import org.apache.ctakes.typesystem.type.refsem.EventProperties;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Feature;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.FileUtils;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.ml.jar.JarClassifierBuilder;
import org.cleartk.ml.liblinear.LibLinearStringOutcomeDataWriter;
import org.cleartk.ml.tksvmlight.model.CompositeKernel;
import org.cleartk.util.ViewUriUtil;

public class EvaluationOfEventProperties
extends Evaluation_ImplBase<Map<String, AnnotationStatistics<String>>> {
    private static final String DOC_TIME_REL = "docTimeRel";
    private static final String CONTEXTUAL_MODALITY = "contextualModality";
    private static final List<String> PROPERTY_NAMES = Arrays.asList("docTimeRel", "contextualModality");
    protected static boolean DEFAULT_BOTH_DIRECTIONS = false;
    protected static float DEFAULT_DOWNSAMPLE = 1.0f;
    protected static EvaluationOfEventTimeRelations.ParameterSettings allParams = new EvaluationOfEventTimeRelations.ParameterSettings(DEFAULT_BOTH_DIRECTIONS, DEFAULT_DOWNSAMPLE, "tk", 10.0, 1.0, "polynomial", CompositeKernel.ComboOperator.SUM, 0.1, 0.5);
    private Map<String, Logger> loggers = Maps.newHashMap();
    protected boolean skipTrain = false;
    protected boolean testOnTrain = false;
    protected EvaluationOfEventTimeRelations.ParameterSettings params = null;

    public static void main(String[] args) throws Exception {
        TempRelOptions options = (TempRelOptions)CliFactory.parseArguments(TempRelOptions.class, (String[])args);
        List<Integer> patientSets = options.getPatients().getList();
        List<Integer> trainItems = EvaluationOfEventProperties.getTrainItems(options);
        List<Integer> testItems = EvaluationOfEventProperties.getTestItems(options);
        EvaluationOfEventTimeRelations.ParameterSettings params = allParams;
        try {
            File workingDir = new File("target/eval/event-properties");
            if (!workingDir.exists()) {
                workingDir.mkdirs();
            }
            if (options.getUseTmp()) {
                File tempModelDir = File.createTempFile("temporal", null, workingDir);
                tempModelDir.delete();
                tempModelDir.mkdir();
                workingDir = tempModelDir;
            }
            EvaluationOfEventProperties evaluation = new EvaluationOfEventProperties(workingDir, options.getRawTextDirectory(), options.getXMLDirectory(), options.getXMLFormat(), options.getSubcorpus(), options.getXMIDirectory(), options.getKernelParams(), params);
            evaluation.skipTrain = options.getSkipTrain();
            if (evaluation.skipTrain && options.getTest()) {
                evaluation.prepareXMIsFor(testItems);
            } else {
                evaluation.prepareXMIsFor(patientSets);
            }
            evaluation.logClassificationErrors(workingDir, "ctakes-event-property-errors");
            Map stats = null;
            Collections.sort(trainItems);
            Collections.sort(testItems);
            evaluation.testOnTrain = options.getTestOnTrain();
            stats = evaluation.testOnTrain ? (Map)evaluation.trainAndTest(trainItems, trainItems) : (Map)evaluation.trainAndTest(trainItems, testItems);
            for (String name : PROPERTY_NAMES) {
                System.err.println("====================");
                System.err.println(name);
                System.err.println("--------------------");
                System.err.println(stats.get(name));
            }
            if (options.getUseTmp()) {
                FileUtils.deleteRecursive((File)workingDir);
            }
        }
        catch (ResourceInitializationException e) {
            System.err.println("Error with Initialization");
            e.printStackTrace();
        }
    }

    public EvaluationOfEventProperties(File baseDirectory, File rawTextDirectory, File xmlDirectory, Evaluation_ImplBase.XMLFormat xmlFormat, Evaluation_ImplBase.Subcorpus subcorpus, File xmiDirectory, String kernelParams, EvaluationOfEventTimeRelations.ParameterSettings params) {
        super(baseDirectory, rawTextDirectory, xmlDirectory, xmlFormat, subcorpus, xmiDirectory, null);
        this.params = params;
        for (String name : PROPERTY_NAMES) {
            this.loggers.put(name, Logger.getLogger(String.format("%s.%s", ((Object)((Object)this)).getClass().getName(), name)));
        }
        this.kernelParams = kernelParams == null ? null : kernelParams.split(" ");
    }

    protected void train(CollectionReader collectionReader, File directory) throws Exception {
        String[] optArray;
        if (this.skipTrain) {
            return;
        }
        AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(Evaluation_ImplBase.CopyFromGold.getDescription(EventMention.class), new String[0]);
        aggregateBuilder.add(Evaluation_ImplBase.CopyFromGold.getDescription(TimeMention.class), new String[0]);
        aggregateBuilder.add(DocTimeRelAnnotator.createDataWriterDescription(LibLinearStringOutcomeDataWriter.class, new File(directory, DOC_TIME_REL)), new String[0]);
        aggregateBuilder.add(ContextualModalityAnnotator.createDataWriterDescription(LibLinearStringOutcomeDataWriter.class, new File(directory, CONTEXTUAL_MODALITY)), new String[0]);
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        if (this.kernelParams == null) {
            ArrayList<String> svmOptions = new ArrayList<String>();
            svmOptions.add("-c");
            svmOptions.add("" + this.params.svmCost);
            svmOptions.add("-t");
            svmOptions.add("" + this.params.svmKernelIndex);
            svmOptions.add("-d");
            svmOptions.add("3");
            svmOptions.add("-g");
            svmOptions.add("" + this.params.svmGamma);
            if (this.params.svmKernelIndex == EvaluationOfEventTimeRelations.ParameterSettings.SVM_KERNELS.indexOf("tk")) {
                svmOptions.add("-S");
                svmOptions.add("" + this.params.secondKernelIndex);
                String comboFlag = this.params.comboOperator == CompositeKernel.ComboOperator.SUM ? "+" : (this.params.comboOperator == CompositeKernel.ComboOperator.PRODUCT ? "*" : (this.params.comboOperator == CompositeKernel.ComboOperator.TREE_ONLY ? "T" : "V"));
                svmOptions.add("-C");
                svmOptions.add(comboFlag);
                svmOptions.add("-L");
                svmOptions.add("" + this.params.lambda);
                svmOptions.add("-T");
                svmOptions.add("" + this.params.tkWeight);
                svmOptions.add("-N");
                svmOptions.add("3");
            }
            optArray = svmOptions.toArray(new String[0]);
        } else {
            optArray = this.kernelParams;
            for (int i = 0; i < optArray.length; i += 2) {
                optArray[i] = "-" + optArray[i];
            }
        }
        String[] weightArray = new String[]{"-c", optArray[1]};
        for (String propertyName : PROPERTY_NAMES) {
            JarClassifierBuilder.trainAndPackage((File)new File(directory, propertyName), (String[])weightArray);
        }
    }

    protected Map<String, AnnotationStatistics<String>> test(CollectionReader collectionReader, File directory) throws Exception {
        AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(Evaluation_ImplBase.CopyFromGold.getDescription(EventMention.class), new String[0]);
        aggregateBuilder.add(Evaluation_ImplBase.CopyFromGold.getDescription(TimeMention.class), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(ClearEventProperties.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(DocTimeRelAnnotator.createAnnotatorDescription(new File(directory, DOC_TIME_REL)), new String[0]);
        aggregateBuilder.add(ContextualModalityAnnotator.createAnnotatorDescription(new File(directory, CONTEXTUAL_MODALITY)), new String[0]);
        Function eventMentionToSpan = AnnotationStatistics.annotationToSpan();
        HashMap<String, Function<EventMention, String>> propertyGetters = new HashMap<String, Function<EventMention, String>>();
        for (String string : PROPERTY_NAMES) {
            propertyGetters.put(string, EvaluationOfEventProperties.getPropertyGetter(string));
        }
        HashMap<String, AnnotationStatistics<String>> statsMap = new HashMap<String, AnnotationStatistics<String>>();
        for (String propertyName : PROPERTY_NAMES) {
            statsMap.put(propertyName, new AnnotationStatistics());
        }
        JCasIterator jCasIterator = new JCasIterator(collectionReader, new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        while (jCasIterator.hasNext()) {
            JCas jCas = (JCas)jCasIterator.next();
            JCas goldView = jCas.getView("GoldView");
            JCas systemView = jCas.getView("_InitialView");
            String text = goldView.getDocumentText();
            for (Segment segment : JCasUtil.select((JCas)jCas, Segment.class)) {
                if (THYMEData.SEGMENTS_TO_SKIP.contains(segment.getId())) continue;
                List<EventMention> goldEvents = EvaluationOfEventProperties.selectExact(goldView, EventMention.class, segment);
                List<EventMention> systemEvents = EvaluationOfEventProperties.selectExact(systemView, EventMention.class, segment);
                for (String name : PROPERTY_NAMES) {
                    this.loggers.get(name).fine("Errors in : " + ViewUriUtil.getURI((JCas)jCas).toString());
                    Function getProperty = (Function)propertyGetters.get(name);
                    ((AnnotationStatistics)statsMap.get(name)).add(goldEvents, systemEvents, eventMentionToSpan, getProperty);
                    for (int i = 0; i < goldEvents.size(); ++i) {
                        String goldOutcome = (String)getProperty.apply((Object)goldEvents.get(i));
                        String systemOutcome = (String)getProperty.apply((Object)systemEvents.get(i));
                        EventMention event = goldEvents.get(i);
                        int begin = event.getBegin();
                        int end = event.getEnd();
                        int windowBegin = Math.max(0, begin - 100);
                        int windowEnd = Math.min(text.length(), end + 100);
                        if (!goldOutcome.equals(systemOutcome)) {
                            this.loggers.get(name).fine(String.format("%s was %s but should be %s, in  ...%s[!%s!:%d-%d]%s...", name, systemOutcome, goldOutcome, text.substring(windowBegin, begin).replaceAll("[\r\n]", " "), text.substring(begin, end), begin, end, text.substring(end, windowEnd).replaceAll("[\r\n]", " ")));
                            continue;
                        }
                        this.loggers.get(name).fine(String.format("%s was correctly labeled as %s, in  ...%s[!%s!:%d-%d]%s...", name, goldOutcome, text.substring(windowBegin, begin).replaceAll("[\r\n]", " "), text.substring(begin, end), begin, end, text.substring(end, windowEnd).replaceAll("[\r\n]", " ")));
                    }
                }
            }
        }
        return statsMap;
    }

    public void logClassificationErrors(File outputDir, String outputFilePrefix) throws IOException {
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        for (String name : PROPERTY_NAMES) {
            Logger logger = this.loggers.get(name);
            logger.setLevel(Level.FINE);
            File outputFile = new File(outputDir, String.format("%s.%s.log", outputFilePrefix, name));
            FileHandler handler = new FileHandler(outputFile.getPath());
            handler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return record.getMessage() + '\n';
                }
            });
            logger.addHandler(handler);
        }
    }

    private static Function<EventMention, String> getPropertyGetter(final String propertyName) {
        return new Function<EventMention, String>(){

            public String apply(EventMention eventMention) {
                EventProperties eventProperties = eventMention.getEvent().getProperties();
                Feature feature = eventProperties.getType().getFeatureByBaseName(propertyName);
                return eventProperties.getFeatureValueAsString(feature);
            }
        };
    }

    @PipeBitInfo(name="Event Property Clearer", description="Clears all event properties.", role=PipeBitInfo.Role.SPECIAL)
    public static class ClearEventProperties
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            for (EventProperties eventProperties : JCasUtil.select((JCas)jCas, EventProperties.class)) {
                eventProperties.setAspect(null);
                eventProperties.setCategory(null);
                eventProperties.setContextualAspect(null);
                eventProperties.setContextualModality(null);
                eventProperties.setDegree(null);
                eventProperties.setDocTimeRel(null);
                eventProperties.setPermanence(null);
                eventProperties.setPolarity(0);
            }
        }
    }

    static interface TempRelOptions
    extends Evaluation_ImplBase.Options {
        @Option
        public boolean getPrintFormattedRelations();

        @Option
        public boolean getBaseline();

        @Option
        public boolean getClosure();

        @Option
        public boolean getUseTmp();

        @Option
        public boolean getUseGoldAttributes();

        @Override
        @Option
        public boolean getSkipTrain();

        @Option
        public boolean getTestOnTrain();
    }
}

