/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.data.analysis;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ctakes.relationextractor.eval.XMIReader;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class EventContextAnalysisPipeline {
    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        List<File> trainFiles = Arrays.asList(options.getInputDirectory().listFiles());
        CollectionReader collectionReader = EventContextAnalysisPipeline.getCollectionReader(trainFiles);
        AnalysisEngine annotationConsumer = AnalysisEngineFactory.createEngine(EventAndTokenContextWriter.class, (Object[])new Object[]{"TokenOutputFile", options.getTokenOutputFile(), "EventOutputFile", options.getEventOutputFile(), "ContextSize", options.getContextSize()});
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{annotationConsumer});
    }

    private static CollectionReader getCollectionReader(List<File> inputFiles) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (File file : inputFiles) {
            if (file.isHidden()) continue;
            fileNames.add(file.getPath());
        }
        String[] paths = new String[fileNames.size()];
        fileNames.toArray(paths);
        return CollectionReaderFactory.createReader(XMIReader.class, (Object[])new Object[]{"files", paths});
    }

    public static class EventAndTokenContextWriter
    extends JCasAnnotator_ImplBase {
        @ConfigurationParameter(name="TokenOutputFile", mandatory=true, description="path to the file that stores token contexts")
        private String tokenOutputFile;
        @ConfigurationParameter(name="EventOutputFile", mandatory=true, description="path to the file that stores event contexts")
        private String eventOutputFile;
        @ConfigurationParameter(name="ContextSize", mandatory=true, description="context size in characters")
        private int contextSize;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            JCas goldView;
            try {
                goldView = jCas.getView("GoldView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            try {
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            BufferedWriter tokenWriter = EventAndTokenContextWriter.getWriter(this.tokenOutputFile, true);
            BufferedWriter eventWriter = EventAndTokenContextWriter.getWriter(this.eventOutputFile, true);
            try {
                String output;
                for (BaseToken baseToken : JCasUtil.select((JCas)systemView, BaseToken.class)) {
                    String tokenText = baseToken.getCoveredText().toLowerCase();
                    output = String.format("%s|%s\n", tokenText, EventAndTokenContextWriter.getAnnotationContext((Annotation)baseToken, this.contextSize));
                    try {
                        tokenWriter.write(output);
                    }
                    catch (IOException e) {
                        throw new AnalysisEngineProcessException((Throwable)e);
                    }
                }
                for (EventMention eventMention : JCasUtil.select((JCas)goldView, EventMention.class)) {
                    String eventText = eventMention.getCoveredText().toLowerCase();
                    output = String.format("%s|%s\n", eventText, EventAndTokenContextWriter.getAnnotationContext((Annotation)eventMention, this.contextSize));
                    try {
                        eventWriter.write(output);
                    }
                    catch (IOException e) {
                        throw new AnalysisEngineProcessException((Throwable)e);
                        return;
                    }
                }
            }
            finally {
                try {
                    tokenWriter.close();
                    eventWriter.close();
                }
                catch (IOException e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
            }
        }

        private static String getAnnotationContext(Annotation annotation, int maxContextWindowSize) {
            String text = annotation.getCAS().getDocumentText();
            int begin = Math.max(0, annotation.getBegin() - maxContextWindowSize);
            int end = Math.min(text.length(), annotation.getEnd() + maxContextWindowSize);
            return text.substring(begin, end).replaceAll("[\r\n]", " ");
        }

        private static BufferedWriter getWriter(String filePath, boolean append) {
            BufferedWriter bufferedWriter = null;
            try {
                FileWriter fileWriter = new FileWriter(filePath, append);
                bufferedWriter = new BufferedWriter(fileWriter);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return bufferedWriter;
        }
    }

    static interface Options {
        @Option(description="specify the path to the directory containing the clinical notes to be processed")
        public File getInputDirectory();

        @Option(description="specify the path to the directory containing the clinical notes to be processed")
        public File getTokenOutputFile();

        @Option(description="specify the path to the directory containing the clinical notes to be processed")
        public File getEventOutputFile();

        @Option(description="specify the number of characters to include on both sides", defaultValue={"50"})
        public int getContextSize();
    }
}

