/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.constituency.parser.treekernel.TreeExtractor;
import org.apache.ctakes.constituency.parser.util.AnnotationTreeUtils;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.TopTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.utils.tree.SimpleTree;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;

public class TemporalPETFlatExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    private static final String FEAT_NAME = "Flat_DPK";

    public List<Feature> extract(JCas jcas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        String timeClass;
        EventMention mention;
        ArrayList<Feature> features = new ArrayList<Feature>();
        TopTreebankNode root = AnnotationTreeUtils.getTreeCopy((JCas)jcas, (TopTreebankNode)AnnotationTreeUtils.getAnnotationTree((JCas)jcas, (Annotation)arg1));
        if (root == null) {
            SimpleTree fakeTree = new SimpleTree("(S (NN null))");
            features.add(new Feature(FEAT_NAME, (Object)fakeTree.toString()));
            return features;
        }
        if (arg2.getBegin() <= arg1.getBegin() && arg2.getEnd() <= arg1.getEnd()) {
            IdentifiedAnnotation temp = arg1;
            arg1 = arg2;
            arg2 = temp;
        }
        String a1type = "";
        String a2type = "";
        String eventModality = "";
        if (arg1 instanceof EventMention) {
            mention = (EventMention)arg1;
            if (mention.getEvent() != null && mention.getEvent().getProperties() != null) {
                eventModality = mention.getEvent().getProperties().getContextualModality();
            }
            a1type = "EVENT-" + eventModality;
        } else if (arg1 instanceof TimeMention) {
            timeClass = ((TimeMention)arg1).getTimeClass();
            a1type = "TIMEX-" + timeClass;
        }
        if (arg2 instanceof EventMention) {
            mention = (EventMention)arg2;
            if (mention.getEvent() != null && mention.getEvent().getProperties() != null) {
                eventModality = mention.getEvent().getProperties().getContextualModality();
            }
            a2type = "EVENT-" + eventModality;
        } else if (arg2 instanceof TimeMention) {
            timeClass = ((TimeMention)arg2).getTimeClass();
            a2type = "TIMEX-" + timeClass;
        }
        TreebankNode t1 = AnnotationTreeUtils.insertAnnotationNode((JCas)jcas, (TopTreebankNode)root, (Annotation)arg1, (String)("ARG1-" + a1type));
        TreebankNode t2 = AnnotationTreeUtils.insertAnnotationNode((JCas)jcas, (TopTreebankNode)root, (Annotation)arg2, (String)("ARG2-" + a2type));
        SimpleTree tree = null;
        tree = t1.getBegin() <= t2.getBegin() && t1.getEnd() >= t2.getEnd() ? TreeExtractor.getSimpleClone((TreebankNode)t1) : (t2.getBegin() <= t1.getBegin() && t2.getEnd() >= t1.getEnd() ? TreeExtractor.getSimpleClone((TreebankNode)t2) : TreeExtractor.extractPathEnclosedTree((TreebankNode)t1, (TreebankNode)t2, (JCas)jcas));
        tree.setGeneralizeLeaf(true);
        TemporalPETFlatExtractor.moveTimexDownToNP(tree);
        TemporalPETFlatExtractor.simplifyGCG(tree);
        features.addAll(this.traverseTreeForDPath(tree));
        return features;
    }

    private List<Feature> traverseTreeForDPath(SimpleTree tree) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        String rootStr = tree.cat;
        features.add(new Feature(FEAT_NAME, (Object)rootStr));
        if (tree.children.size() == 1 && ((SimpleTree)tree.children.get((int)0)).children.size() == 0) {
            features.add(new Feature(FEAT_NAME, (Object)(rootStr + "-" + ((SimpleTree)tree.children.get((int)0)).cat)));
        } else {
            for (SimpleTree subtree : tree.children) {
                features.addAll(this.traverseTreeForDPath(subtree));
                for (String str : this.getSubTreeStrings(subtree)) {
                    features.add(new Feature(FEAT_NAME, (Object)(rootStr + "-" + str)));
                }
            }
        }
        return features;
    }

    private List<String> getSubTreeStrings(SimpleTree subtree) {
        ArrayList<String> subTreeStrings = new ArrayList<String>();
        subTreeStrings.add(subtree.cat);
        if (subtree.children.size() == 1 && ((SimpleTree)subtree.children.get((int)0)).children.size() == 0) {
            subTreeStrings.add(subtree.cat + "-" + ((SimpleTree)subtree.children.get((int)0)).cat);
        } else {
            for (SimpleTree subsubTree : subtree.children) {
                for (String str : this.getSubTreeStrings(subsubTree)) {
                    subTreeStrings.add(subtree.cat + "-" + str);
                }
            }
        }
        return subTreeStrings;
    }

    public static void addOtherTimes(JCas jcas, TopTreebankNode root, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) {
        List timexes = JCasUtil.selectCovered(TimeMention.class, (AnnotationFS)root);
        for (TimeMention timex : timexes) {
            if (timex.getBegin() == arg1.getBegin() && timex.getEnd() == arg1.getEnd() || timex.getBegin() == arg2.getBegin() && timex.getEnd() == arg2.getEnd() || timex.getBegin() <= arg1.getBegin() || timex.getEnd() > arg2.getBegin()) continue;
            AnnotationTreeUtils.insertAnnotationNode((JCas)jcas, (TopTreebankNode)root, (Annotation)timex, (String)"TIMEX");
        }
    }

    public static void moveTimexDownToNP(SimpleTree tree) {
        if (tree.cat.contains("-TIMEX-")) {
            SimpleTree child = (SimpleTree)tree.children.get(0);
            if (child.cat.contains("PP") && child.children.size() == 2 && ((SimpleTree)child.children.get((int)0)).cat.equals("IN") && ((SimpleTree)child.children.get((int)1)).cat.startsWith("NP")) {
                String fullCat = tree.cat;
                tree.cat = "PP";
                child.cat = fullCat;
                tree.children.add(0, child.children.get(0));
                child.children.remove(0);
            }
            return;
        }
        if (tree.children == null || tree.children.size() == 0) {
            return;
        }
        for (SimpleTree child : tree.children) {
            TemporalPETFlatExtractor.moveTimexDownToNP(child);
        }
    }

    public static void simplifyGCG(SimpleTree tree) {
        if (tree.children == null || tree.children.size() == 0) {
            return;
        }
        int ampInd = tree.cat.indexOf(43);
        if (ampInd > 0) {
            tree.cat = tree.cat.substring(0, ampInd);
        }
        for (SimpleTree child : tree.children) {
            TemporalPETFlatExtractor.simplifyGCG(child);
        }
    }
}

