/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.Predicate;
import org.apache.ctakes.typesystem.type.textsem.SemanticArgument;
import org.apache.ctakes.typesystem.type.textsem.SemanticRoleRelation;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class PredicateArgumentExtractor {
    private Multimap<BaseToken, Predicate> tokenPredicateMap = ArrayListMultimap.create();
    private Multimap<BaseToken, SemanticArgument> tokenArgumentMap;

    public PredicateArgumentExtractor(JCas jCas) {
        for (Predicate predicate : JCasUtil.select((JCas)jCas, Predicate.class)) {
            for (BaseToken token : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)predicate)) {
                this.tokenPredicateMap.put((Object)token, (Object)predicate);
            }
        }
        this.tokenArgumentMap = ArrayListMultimap.create();
        for (SemanticArgument argument : JCasUtil.select((JCas)jCas, SemanticArgument.class)) {
            for (BaseToken token : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)argument)) {
                this.tokenArgumentMap.put((Object)token, (Object)argument);
            }
        }
    }

    public List<Feature> extract(BaseToken token) {
        ArrayList features = Lists.newArrayList();
        Collection predicates = this.tokenPredicateMap.get((Object)token);
        features.add(new Feature("Predicate", (Object)(!predicates.isEmpty() ? 1 : 0)));
        for (Predicate predicate : predicates) {
            features.add(new Feature("Predicate_Lex", (Object)predicate.getCoveredText()));
        }
        for (SemanticArgument argument : this.tokenArgumentMap.get((Object)token)) {
            SemanticRoleRelation relation = argument.getRelation();
            String category = relation.getCategory();
            features.add(new Feature("Argument", (Object)category));
            String predicateText = relation.getPredicate().getCoveredText();
            features.add(new Feature("Argument_Lex", (Object)String.format("%s_%s", category, predicateText)));
        }
        return features;
    }
}

