/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.temporal.ae.TemporalSequenceAnnotator_ImplBase;
import org.apache.ctakes.temporal.ae.feature.ParseSpanFeatureExtractor;
import org.apache.ctakes.temporal.ae.feature.TimeWordTypeExtractor;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instances;
import org.cleartk.ml.chunking.BioChunking;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CombinedExtractor1;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.TypePathExtractor;

@PipeBitInfo(name="Timex Annotator", description="Annotates absolute time / date Temporal expressions into a View.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.BASE_TOKEN}, products={PipeBitInfo.TypeProduct.TIMEX})
public class CRFTimeAnnotator
extends TemporalSequenceAnnotator_ImplBase {
    public static final String PARAM_TIMEX_VIEW = "TimexView";
    @ConfigurationParameter(name="TimexView", mandatory=false, description="View to write timexes to (used for ensemble methods)")
    protected String timexView = "_InitialView";
    protected List<FeatureExtractor1> tokenFeatureExtractors;
    protected List<CleartkExtractor> contextFeatureExtractors;
    protected ParseSpanFeatureExtractor parseExtractor;
    private BioChunking<BaseToken, TimeMention> timeChunking;

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(CRFTimeAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createEnsembleDescription(String modelPath, String viewName) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(CRFTimeAnnotator.class, (Object[])new Object[]{"isTraining", false, PARAM_TIMEX_VIEW, viewName, "classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(File modelDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(CRFTimeAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", new File(modelDirectory, "model.jar")});
    }

    public static AnalysisEngineDescription createEnsembleDescription(File modelDirectory, String viewName) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(CRFTimeAnnotator.class, (Object[])new Object[]{"isTraining", false, PARAM_TIMEX_VIEW, viewName, "classifierJarPath", new File(modelDirectory, "model.jar")});
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.timeChunking = new BioChunking(BaseToken.class, TimeMention.class);
        CombinedExtractor1 allExtractors = new CombinedExtractor1((FeatureExtractor1)new CoveredTextExtractor(), (FeatureExtractor1)new TypePathExtractor(BaseToken.class, "partOfSpeech"), new TimeWordTypeExtractor());
        this.tokenFeatureExtractors = new ArrayList<FeatureExtractor1>();
        this.tokenFeatureExtractors.add((FeatureExtractor1)allExtractors);
        this.contextFeatureExtractors = new ArrayList<CleartkExtractor>();
        this.contextFeatureExtractors.add(new CleartkExtractor(BaseToken.class, (FeatureExtractor1)allExtractors, new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(2), new CleartkExtractor.Following(2)}));
        this.parseExtractor = new ParseSpanFeatureExtractor();
    }

    @Override
    public void process(JCas jCas, Segment segment) throws AnalysisEngineProcessException {
        for (Sentence sentence : JCasUtil.selectCovered((JCas)jCas, Sentence.class, (AnnotationFS)segment)) {
            JCas timexCas;
            List outcomes;
            List tokens = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)sentence);
            if (this.isTraining()) {
                List times = JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (AnnotationFS)sentence);
                outcomes = this.timeChunking.createOutcomes(jCas, tokens, times);
            } else {
                outcomes = new ArrayList();
            }
            ArrayList allFeatures = new ArrayList();
            for (BaseToken token : tokens) {
                ArrayList<Feature> features = new ArrayList<Feature>();
                for (FeatureExtractor1 featureExtractor1 : this.tokenFeatureExtractors) {
                    features.addAll(featureExtractor1.extract(jCas, (Annotation)token));
                }
                for (CleartkExtractor cleartkExtractor : this.contextFeatureExtractors) {
                    features.addAll(cleartkExtractor.extractWithin(jCas, (Annotation)token, (Annotation)sentence));
                }
                features.addAll(this.parseExtractor.extract(jCas, token.getBegin(), token.getEnd()));
                allFeatures.add(features);
            }
            if (this.isTraining()) {
                this.dataWriter.write(Instances.toInstances(outcomes, allFeatures));
                continue;
            }
            outcomes = this.classifier.classify(allFeatures);
            try {
                timexCas = jCas.getView(this.timexView);
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            this.timeChunking.createChunks(timexCas, tokens, outcomes);
        }
    }
}

