/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.feature.xml;

import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.feature.xml.AbstractFtrXml;
import com.googlecode.clearnlp.util.UTXml;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SRLFtrXml
extends AbstractFtrXml {
    private static final String CUTOFF_DOWN = "down";
    private static final String CUTOFF_UP = "up";
    public static final char S_PREDICAT = 'p';
    public static final char S_ARGUMENT = 'a';
    public static final String R_H = "h";
    public static final String R_LMD = "lmd";
    public static final String R_RMD = "rmd";
    public static final String R_LND = "lnd";
    public static final String R_RND = "rnd";
    public static final String R_LNS = "lns";
    public static final String R_RNS = "rns";
    public static final String F_FORM = "f";
    public static final String F_LEMMA = "m";
    public static final String F_POS = "p";
    public static final String F_DEPREL = "d";
    public static final String F_DISTANCE = "n";
    public static final String F_DEPREL_SET = "ds";
    public static final String F_GRAND_DEPREL_SET = "gds";
    public static final Pattern P_FEAT = Pattern.compile("^ft=(.+)$");
    public static final Pattern P_BOOLEAN = Pattern.compile("^b(\\d+)$");
    public static final Pattern P_SUBCAT = Pattern.compile("^sc([pd])(\\d+)$");
    public static final Pattern P_PATH = Pattern.compile("^pt([pdn])(\\d+)$");
    public static final Pattern P_ARGN = Pattern.compile("^argn(\\d+)$");
    protected static final Pattern P_REL = Pattern.compile("h|lmd|rmd|lnd|rnd|lns|rns");
    protected static final Pattern P_FIELD = Pattern.compile("f|m|p|d|n|ds|gds");
    protected final String XML_LEXICA_PREDICATE = "predicate";
    private int cutoff_down;
    private int cutoff_up;
    private Pattern p_predicates;

    public SRLFtrXml(InputStream fin) {
        super(fin);
    }

    public SRLFtrXml(InputStream fin, boolean skipInvisible) {
        super(fin, skipInvisible);
    }

    @Override
    protected void initCutoffMore(NodeList eList) {
        int size = eList.getLength();
        for (int i = 0; i < size; ++i) {
            Element eCutoff = (Element)eList.item(i);
            this.cutoff_down = eCutoff.hasAttribute(CUTOFF_DOWN) ? Integer.parseInt(eCutoff.getAttribute(CUTOFF_DOWN)) : 0;
            this.cutoff_up = eCutoff.hasAttribute(CUTOFF_UP) ? Integer.parseInt(eCutoff.getAttribute(CUTOFF_UP)) : 0;
        }
    }

    public int getDownCutoff() {
        return this.cutoff_down;
    }

    public int getUpCutoff() {
        return this.cutoff_up;
    }

    public boolean isPredicate(DEPNode node) {
        return this.p_predicates.matcher(node.pos).find();
    }

    @Override
    protected void initMore(Document doc) throws Exception {
        this.initMoreLexica(doc);
    }

    private void initMoreLexica(Document doc) {
        NodeList eList = doc.getElementsByTagName("lexica");
        int size = eList.getLength();
        for (int i = 0; i < size; ++i) {
            Element eLexica = (Element)eList.item(i);
            String type = UTXml.getTrimmedAttribute(eLexica, "type");
            String label = UTXml.getTrimmedAttribute(eLexica, "label");
            if (!type.equals("predicate")) continue;
            this.p_predicates = Pattern.compile("^" + label + "$");
        }
    }

    @Override
    protected boolean validSource(char source) {
        return source == 'p' || source == 'a';
    }

    @Override
    protected boolean validRelation(String relation) {
        return P_REL.matcher(relation).matches();
    }

    @Override
    protected boolean validField(String field) {
        return P_FIELD.matcher(field).matches() || P_FEAT.matcher(field).matches() || P_BOOLEAN.matcher(field).matches() || P_SUBCAT.matcher(field).matches() || P_PATH.matcher(field).matches() || P_ARGN.matcher(field).matches();
    }
}

