/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.classification.model;

import com.carrotsearch.hppc.ObjectIntOpenHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.googlecode.clearnlp.classification.model.AbstractModel;
import com.googlecode.clearnlp.classification.prediction.StringPrediction;
import com.googlecode.clearnlp.classification.vector.SparseFeatureVector;
import com.googlecode.clearnlp.classification.vector.StringFeatureVector;
import com.googlecode.clearnlp.util.pair.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class StringModel
extends AbstractModel {
    protected Map<String, ObjectIntOpenHashMap<String>> m_features;

    public StringModel() {
        this.m_features = new HashMap<String, ObjectIntOpenHashMap<String>>();
    }

    public StringModel(BufferedReader reader) {
        super(reader);
    }

    @Override
    public void load(BufferedReader reader) {
        System.out.println("Loading model:");
        try {
            this.i_solver = Byte.parseByte(reader.readLine());
            this.loadLabels(reader);
            this.loadFeatures(reader);
            this.loadWeightVector(reader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println();
    }

    @Override
    public void save(PrintStream fout) {
        System.out.println("Saving model:");
        try {
            fout.println(this.i_solver);
            this.saveLabels(fout);
            this.saveFeatures(fout);
            this.saveWeightVector(fout);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println();
    }

    protected void loadFeatures(BufferedReader fin) throws IOException {
        this.n_features = Integer.parseInt(fin.readLine());
        int typeSize = Integer.parseInt(fin.readLine());
        this.m_features = new HashMap<String, ObjectIntOpenHashMap<String>>();
        Pattern P_DELIM = Pattern.compile(" ");
        for (int i = 0; i < typeSize; ++i) {
            ObjectIntOpenHashMap map = new ObjectIntOpenHashMap();
            String type = fin.readLine();
            int valueSize = Integer.parseInt(fin.readLine());
            for (int j = 0; j < valueSize; ++j) {
                String[] tmp = P_DELIM.split(fin.readLine());
                map.put((Object)tmp[0], Integer.parseInt(tmp[1]));
            }
            this.m_features.put(type, (ObjectIntOpenHashMap<String>)map);
        }
    }

    protected void saveFeatures(PrintStream fout) {
        fout.println(this.n_features);
        fout.println(this.m_features.size());
        for (String type : this.m_features.keySet()) {
            ObjectIntOpenHashMap<String> map = this.m_features.get(type);
            fout.println(type);
            fout.println(map.size());
            for (ObjectCursor cur : map.keys()) {
                String value = (String)cur.value;
                StringBuilder build = new StringBuilder();
                build.append(value);
                build.append(" ");
                build.append(map.get((Object)value));
                fout.println(build.toString());
            }
        }
    }

    public void addFeature(String type, String value) {
        if (this.m_features.containsKey(type)) {
            ObjectIntOpenHashMap<String> map = this.m_features.get(type);
            if (!map.containsKey((Object)value)) {
                map.put((Object)value, this.n_features++);
            }
        } else {
            ObjectIntOpenHashMap map = new ObjectIntOpenHashMap();
            map.put((Object)value, this.n_features++);
            this.m_features.put(type, (ObjectIntOpenHashMap<String>)map);
        }
    }

    public SparseFeatureVector toSparseFeatureVector(StringFeatureVector vector) {
        SparseFeatureVector sparse = new SparseFeatureVector(vector.hasWeight());
        int size = vector.size();
        for (int i = 0; i < size; ++i) {
            int index;
            String type = vector.getType(i);
            String value = vector.getValue(i);
            ObjectIntOpenHashMap<String> map = this.m_features.get(type);
            if (map == null || (index = map.get((Object)value)) <= 0) continue;
            if (sparse.hasWeight()) {
                sparse.addFeature(index, vector.getWeight(i));
                continue;
            }
            sparse.addFeature(index);
        }
        sparse.trimToSize();
        return sparse;
    }

    public StringPrediction predictBest(StringFeatureVector x) {
        return this.predictBest(this.toSparseFeatureVector(x));
    }

    public Pair<StringPrediction, StringPrediction> predictTwo(StringFeatureVector x) {
        return this.predictTwo(this.toSparseFeatureVector(x));
    }

    public List<StringPrediction> predictAll(StringFeatureVector x) {
        return this.predictAll(this.toSparseFeatureVector(x));
    }

    public List<StringPrediction> getPredictions(StringFeatureVector x) {
        return this.getPredictions(this.toSparseFeatureVector(x));
    }
}

