/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.classification.algorithm;

import com.carrotsearch.hppc.IntArrayList;
import com.googlecode.clearnlp.classification.algorithm.AbstractAlgorithm;
import com.googlecode.clearnlp.classification.train.AbstractTrainSpace;
import com.googlecode.clearnlp.util.UTArray;
import java.util.ArrayList;
import java.util.Random;

public class LiblinearL2SV
extends AbstractAlgorithm {
    protected byte i_lossType;
    protected double d_cost;
    protected double d_eps;
    protected double d_bias;

    public LiblinearL2SV(byte lossType, double cost, double eps, double bias) {
        this.i_lossType = lossType;
        this.d_cost = cost;
        this.d_eps = eps;
        this.d_bias = bias;
    }

    @Override
    public double[] getWeight(AbstractTrainSpace space, int currLabel) {
        int iter;
        int i;
        Random rand = new Random(5L);
        int MAX_ITER = 1000;
        int N = space.getInstanceSize();
        int D = space.getFeatureSize();
        IntArrayList ys = space.getYs();
        ArrayList<int[]> xs = space.getXs();
        ArrayList<double[]> vs = space.getVs();
        double[] QD = new double[N];
        double[] alpha = new double[N];
        double[] weight = new double[D];
        int[] index = new int[N];
        byte[] aY = new byte[N];
        int active_size = N;
        double[] vi = null;
        boolean bBias = this.d_bias > 0.0;
        double PGmax_old = Double.POSITIVE_INFINITY;
        double PGmin_old = Double.NEGATIVE_INFINITY;
        double diag = 0.0;
        double upper_bound = this.d_cost;
        if (this.i_lossType == 2) {
            diag = 0.5 / this.d_cost;
            upper_bound = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < N; ++i) {
            index[i] = i;
            aY[i] = ys.get(i) == currLabel ? 1 : -1;
            QD[i] = diag;
            if (bBias) {
                int n = i;
                QD[n] = QD[n] + this.d_bias * this.d_bias;
            }
            if (space.hasWeight()) {
                for (double value : vs.get(i)) {
                    int n = i;
                    QD[n] = QD[n] + value * value;
                }
                continue;
            }
            int n = i;
            QD[n] = QD[n] + (double)xs.get(i).length;
        }
        for (iter = 0; iter < 1000; ++iter) {
            int j;
            double PGmax_new = Double.NEGATIVE_INFINITY;
            double PGmin_new = Double.POSITIVE_INFINITY;
            for (i = 0; i < active_size; ++i) {
                j = i + rand.nextInt(active_size - i);
                UTArray.swap(index, i, j);
            }
            for (int s = 0; s < active_size; ++s) {
                double PG;
                double G;
                i = index[s];
                byte yi = aY[i];
                int[] xi = xs.get(i);
                double U = upper_bound;
                double d = G = bBias ? weight[0] * this.d_bias : 0.0;
                if (space.hasWeight()) {
                    vi = vs.get(i);
                    for (j = 0; j < xi.length; ++j) {
                        G += weight[xi[j]] * vi[j];
                    }
                } else {
                    for (j = 0; j < xi.length; ++j) {
                        G += weight[xi[j]];
                    }
                }
                G = G * (double)yi - 1.0;
                G += alpha[i] * diag;
                if (alpha[i] == 0.0) {
                    if (G > PGmax_old) {
                        UTArray.swap(index, s, --active_size);
                        --s;
                        continue;
                    }
                    PG = Math.min(G, 0.0);
                } else if (alpha[i] == U) {
                    if (G < PGmin_old) {
                        UTArray.swap(index, s, --active_size);
                        --s;
                        continue;
                    }
                    PG = Math.max(G, 0.0);
                } else {
                    PG = G;
                }
                PGmax_new = Math.max(PGmax_new, PG);
                PGmin_new = Math.min(PGmin_new, PG);
                if (!(Math.abs(PG) > 1.0E-12)) continue;
                double alpha_old = alpha[i];
                alpha[i] = Math.min(Math.max(alpha[i] - G / QD[i], 0.0), U);
                double d2 = (alpha[i] - alpha_old) * (double)yi;
                if (bBias) {
                    weight[0] = weight[0] + d2 * this.d_bias;
                }
                for (j = 0; j < xi.length; ++j) {
                    if (space.hasWeight()) {
                        int n = xi[j];
                        weight[n] = weight[n] + d2 * vi[j];
                        continue;
                    }
                    int n = xi[j];
                    weight[n] = weight[n] + d2;
                }
            }
            if (PGmax_new - PGmin_new <= this.d_eps) {
                if (active_size == N) break;
                active_size = N;
                PGmax_old = Double.POSITIVE_INFINITY;
                PGmin_old = Double.NEGATIVE_INFINITY;
                continue;
            }
            PGmax_old = PGmax_new;
            PGmin_old = PGmin_new;
            if (PGmax_old <= 0.0) {
                PGmax_old = Double.POSITIVE_INFINITY;
            }
            if (!(PGmin_old >= 0.0)) continue;
            PGmin_old = Double.NEGATIVE_INFINITY;
        }
        int nSV = 0;
        for (i = 0; i < N; ++i) {
            if (!(alpha[i] > 0.0)) continue;
            ++nSV;
        }
        System.out.printf("- label = %3d: iter = %4d, nSV = %5d\n", currLabel, iter, nSV);
        return weight;
    }
}

