/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Lib;

import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Gender;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

public class BitMaskBase {
    protected static final int MAX_BIT = 63;
    private static final String SP = "+";
    private static final String ALL_STR = "all";
    public static final long[] MASK = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L, 0x100000000L, 0x200000000L, 0x400000000L, 0x800000000L, 0x1000000000L, 0x2000000000L, 0x4000000000L, 0x8000000000L, 0x10000000000L, 0x20000000000L, 0x40000000000L, 0x80000000000L, 0x100000000000L, 0x200000000000L, 0x400000000000L, 0x800000000000L, 0x1000000000000L, 0x2000000000000L, 0x4000000000000L, 0x8000000000000L, 0x10000000000000L, 0x20000000000000L, 0x40000000000000L, 0x80000000000000L, 0x100000000000000L, 0x200000000000000L, 0x400000000000000L, 0x800000000000000L, 0x1000000000000000L, 0x2000000000000000L, 0x4000000000000000L};
    private long value_;
    private long allBitValue_ = -1L;
    private ArrayList<Vector<String>> bitStr_ = new ArrayList(63);

    public BitMaskBase() {
        this.value_ = 0L;
    }

    public BitMaskBase(long value) {
        this.value_ = value;
    }

    protected BitMaskBase(long allBitValue, ArrayList<Vector<String>> bitStr) {
        this.value_ = 0L;
        this.allBitValue_ = allBitValue;
        this.bitStr_ = bitStr;
    }

    protected BitMaskBase(long value, long allBitValue, ArrayList<Vector<String>> bitStr) {
        this.value_ = value;
        this.allBitValue_ = allBitValue;
        this.bitStr_ = bitStr;
    }

    public static long GetBitValue(int bitNum) {
        return MASK[bitNum];
    }

    public static int GetBitIndex(long value) {
        int bit = -1;
        for (int i = 0; i < 63; ++i) {
            if (value != MASK[i]) continue;
            bit = i;
            break;
        }
        return bit;
    }

    public static boolean Contains(long container, long value) {
        boolean contain = (container & value) == value;
        return contain;
    }

    protected static Vector<Long> ToValues(long value, int maxBitUsed) {
        if (value <= 0L && value > MASK[maxBitUsed]) {
            return null;
        }
        Vector<Long> outs = new Vector<Long>();
        for (int i = 0; i < maxBitUsed; ++i) {
            if ((value & MASK[i]) == 0L) continue;
            outs.addElement(new Long(MASK[i]));
        }
        return outs;
    }

    public void SetValue(long value) {
        if (value > 0L) {
            this.value_ = value;
        }
    }

    public boolean GetBitFlag(int maskIndex) {
        boolean bitValue = (this.value_ & MASK[maskIndex]) != 0L;
        return bitValue;
    }

    public void SetBitFlag(int maskIndex, boolean flag) {
        this.value_ = flag ? (this.value_ |= MASK[maskIndex]) : (this.value_ &= MASK[maskIndex] ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public long GetValue() {
        return this.value_;
    }

    public String GetName() {
        return BitMaskBase.ToName(this.value_, this.allBitValue_, this.bitStr_);
    }

    public boolean Contains(long value) {
        return (this.value_ & value) == value;
    }

    protected static long ToValue(String valueStr, ArrayList<Vector<String>> bitStr) {
        long value = 0L;
        Vector<String> valueStrList = BitMaskBase.GetStringList(valueStr);
        BitMaskBase bm = new BitMaskBase();
        for (int k = 0; k < valueStrList.size(); ++k) {
            for (int i = 0; i < 63; ++i) {
                for (int j = 0; j < bitStr.get(i).size(); ++j) {
                    String temp = valueStrList.elementAt(k);
                    if (!temp.equals(bitStr.get(i).elementAt(j))) continue;
                    bm.SetBitFlag(i, true);
                }
            }
        }
        value = bm.GetValue();
        return value;
    }

    protected static String ToName(long value, long allBitValue, ArrayList<Vector<String>> bitStr) {
        if (value == allBitValue) {
            return ALL_STR;
        }
        String returnBitStr = null;
        for (int i = 0; i < 63; ++i) {
            if (bitStr.get(i).size() < 1 || (value & MASK[i]) == 0L) continue;
            returnBitStr = returnBitStr == null ? bitStr.get(i).elementAt(0) + SP : returnBitStr + bitStr.get(i).elementAt(0) + SP;
        }
        returnBitStr = returnBitStr != null ? returnBitStr.substring(0, returnBitStr.length() - 1) : new String();
        return returnBitStr;
    }

    protected static long Enumerate(String valueStr, ArrayList<Vector<String>> bitStr) {
        long value = 0L;
        block0: for (int i = 0; i < bitStr.size(); ++i) {
            for (int j = 0; j < bitStr.get(i).size(); ++j) {
                if (!valueStr.equals(bitStr.get(i).elementAt(j))) continue;
                value = MASK[i];
                continue block0;
            }
        }
        return value;
    }

    protected static String GetBitName(int bitValue, int index, ArrayList<Vector<String>> bitStr) {
        String returnBitStr = null;
        if (bitValue >= 63) {
            return returnBitStr;
        }
        if (index < bitStr.get(bitValue).size()) {
            returnBitStr = bitStr.get(bitValue).elementAt(index);
        }
        return returnBitStr;
    }

    public static void main(String[] args) {
        int i;
        System.out.println("----- static methods -------");
        System.out.println(" -  Gender.ToName(7): " + Gender.ToName(7L));
        System.out.println(" -  Gender.ToName(15): " + Gender.ToName(15L));
        System.out.println(" -  " + Gender.ToName(6L) + " contains " + Gender.ToName(2L) + ": " + Gender.Contains(6L, 2L));
        System.out.println(" -  " + Gender.ToName(6L) + " contains " + Gender.ToName(4L) + ": " + Gender.Contains(6L, 4L));
        System.out.println(" -  " + Gender.ToName(6L) + " contains " + Gender.ToName(5L) + ": " + Gender.Contains(6L, 5L));
        System.out.println(" -  Category.ToName(1030): " + Category.ToName(1030L));
        Vector<Long> values = Category.ToValues(1030L);
        for (i = 0; i < values.size(); ++i) {
            System.out.println(" - Category.ToValues(1030): " + values.elementAt(i));
        }
        System.out.println(" -  Category.ToName(2047): " + Category.ToName(2047L));
        System.out.println(" -  Inflection.ToName(2584): " + Inflection.ToName(2584L));
        System.out.println(" -  Inflection.ToName(16777215): " + Inflection.ToName(0xFFFFFFL));
        for (i = 0; i < 63; ++i) {
            System.out.println(i + ": " + MASK[i]);
        }
    }

    private static Vector<String> GetStringList(String value) {
        Vector<String> stringList = new Vector<String>();
        StringTokenizer buf = new StringTokenizer(value, SP);
        while (buf.hasMoreTokens()) {
            stringList.addElement(buf.nextToken());
        }
        return stringList;
    }
}

