/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.ToStripPunctuation;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.Word;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToStripPunctuationEnhanced
extends Transformation
implements Cloneable {
    private static final String INFO = "Strip Punctuation Enchanced";

    public static Vector<LexItem> Mutate(LexItem in, boolean detailsFlag, boolean mutateFlag) {
        String term = ToStripPunctuationEnhanced.StripPunctuationEnhanced(in.GetSourceTerm());
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = INFO;
        }
        if (mutateFlag) {
            mutate = Transformation.NO_MUTATE_INFO;
        }
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToStripPunctuationEnhanced.UpdateLexItem(in, term, 6, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }

    public static void main(String[] args) {
        String testStr = ToStripPunctuationEnhanced.GetTestStr(args, "Left's 12.34.56");
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToStripPunctuationEnhanced.Mutate(in, true, true);
        ToStripPunctuationEnhanced.PrintResults(in, outs);
    }

    private static String StripPunctuationEnhanced(String inStr) {
        StringTokenizer buf = new StringTokenizer(inStr, " \t");
        String word = null;
        Vector<String> strList = new Vector<String>();
        while (buf.hasMoreTokens()) {
            word = ToStripPunctuationEnhanced.StripPunctuationFromWord(buf.nextToken());
            strList.addElement(word);
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < strList.size(); ++i) {
            buffer.append((String)strList.elementAt(i));
            buffer.append(" ");
        }
        String out = buffer.toString();
        return out.trim();
    }

    static String StripPunctuationFromWord(String inWord) {
        if (!Word.HasPunctuation(inWord)) {
            return inWord;
        }
        if (Word.IsCatelogNumber(inWord)) {
            return inWord;
        }
        inWord = inWord.replace('-', ' ');
        return ToStripPunctuation.StripPunctuation(inWord);
    }
}

