/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.Char;
import java.util.Vector;

public class ToReplacePunctuationWithSpace
extends Transformation
implements Cloneable {
    private static final String INFO = "Replace Punctuation With Space";

    public static Vector<LexItem> Mutate(LexItem in, boolean detailsFlag, boolean mutateFlag) {
        String term = ToReplacePunctuationWithSpace.ReplacePunctuationWithSpace(in.GetSourceTerm());
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = INFO;
        }
        if (mutateFlag) {
            mutate = Transformation.NO_MUTATE_INFO;
        }
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToReplacePunctuationWithSpace.UpdateLexItem(in, term, 4, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }

    public static void main(String[] args) {
        String testStr = ToReplacePunctuationWithSpace.GetTestStr(args, "2-aryl-1,3-dithiolane");
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToReplacePunctuationWithSpace.Mutate(in, true, true);
        ToReplacePunctuationWithSpace.PrintResults(in, outs);
    }

    static String ReplacePunctuationWithSpace(String inStr) {
        char[] temp = inStr.toCharArray();
        for (int i = 0; i < temp.length; ++i) {
            if (!Char.IsPunctuation(temp[i])) continue;
            temp[i] = 32;
        }
        String out = new String(temp);
        return out;
    }
}

