/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.component.linkbutton;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.render.Renderer;
import org.icefaces.component.linkbutton.LinkButton;
import org.icefaces.component.utils.JSONBuilder;
import org.icefaces.component.utils.ScriptWriter;
import org.icefaces.component.utils.Utils;
import org.icefaces.render.MandatoryResourceComponent;
import org.icefaces.util.EnvUtils;

@MandatoryResourceComponent(value="org.icefaces.component.linkbutton.LinkButton")
public class LinkButtonRenderer
extends Renderer {
    List<UIParameter> uiParamChildren;

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey("ice.event.captured")) {
            LinkButton link = (LinkButton)uiComponent;
            String source = String.valueOf(requestParameterMap.get("ice.event.captured"));
            String clientId = link.getClientId();
            if (clientId.equals(source)) {
                try {
                    uiComponent.queueEvent((FacesEvent)new ActionEvent(uiComponent));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String myStyleClass;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        LinkButton linkButton = (LinkButton)uiComponent;
        this.uiParamChildren = Utils.captureParameters((UIComponent)linkButton);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)"ice-linkbutton", null);
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_span"), null);
        String styleClass = "yui-button yui-link-button";
        boolean disabled = linkButton.isDisabled();
        if (disabled) {
            styleClass = styleClass + " yui-button-disabled yui-link-button-disabled";
        }
        if ((myStyleClass = linkButton.getStyleClass()) != null && !"".equals(myStyleClass)) {
            styleClass = styleClass + " " + myStyleClass;
        }
        writer.writeAttribute("class", (Object)styleClass, null);
        String style = linkButton.getStyle();
        if (style != null && style.trim().length() > 0) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("span", uiComponent);
        styleClass = "first-child";
        if (myStyleClass != null && !"".equals(myStyleClass)) {
            styleClass = styleClass + " " + myStyleClass;
        }
        writer.writeAttribute("class", (Object)styleClass, null);
        if (disabled) {
            return;
        }
        writer.startElement("a", uiComponent);
        writer.writeAttribute("onclick", (Object)("return ice.component.linkButton.clickHandler(event, '" + clientId + "' );"), null);
        String temp = linkButton.getHref();
        if (temp != null) {
            if (this.uiParamChildren != null) {
                temp = temp + "?" + Utils.asParameterString(this.uiParamChildren);
            }
            writer.writeAttribute("href", (Object)temp, null);
        } else {
            writer.writeAttribute("onkeydown", (Object)("return ice.component.linkButton.keyDownHandler(event, '" + clientId + "' );"), null);
        }
        temp = linkButton.getHrefLang();
        if (temp != null) {
            writer.writeAttribute("hreflang", (Object)temp, null);
        }
        if ((temp = linkButton.getTarget()) != null) {
            writer.writeAttribute("target", (Object)temp, null);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        LinkButton linkButton = (LinkButton)uiComponent;
        String value = (String)linkButton.getValue();
        writer.writeText((Object)value, null);
        boolean disabled = linkButton.isDisabled();
        if (!disabled) {
            writer.endElement("a");
        }
        writer.endElement("span");
        writer.endElement("span");
        ActionListener[] al = linkButton.getActionListeners();
        boolean doAction = al.length > 0 || linkButton.getActionExpression() != null;
        StringBuilder sb = new StringBuilder();
        sb.append(value).append(linkButton.getHref()).append(linkButton.getHrefLang()).append(linkButton.getStyleClass()).append(linkButton.getStyle()).append(linkButton.getTarget());
        boolean ariaEnabled = EnvUtils.isAriaEnabled((FacesContext)facesContext);
        Integer tabindex = linkButton.getTabindex();
        if (ariaEnabled && tabindex == null) {
            tabindex = 0;
        }
        JSONBuilder jsonBuilder = JSONBuilder.create().beginMap();
        jsonBuilder.entry("type", "link");
        if (tabindex != null) {
            jsonBuilder.entry("tabindex", tabindex);
        }
        jsonBuilder.entry("label", (String)linkButton.getValue());
        String jsProps = jsonBuilder.entry("disabled", disabled).endMap().toString();
        JSONBuilder jBuild = JSONBuilder.create().beginMap().entry("singleSubmit", linkButton.isSingleSubmit()).entry("doAction", doAction).entry("hashCode", sb.toString().hashCode()).entry("ariaEnabled", ariaEnabled);
        if (doAction && this.uiParamChildren != null) {
            jBuild.entry("postParameters", Utils.asStringArray(this.uiParamChildren));
        }
        String params = "'" + clientId + "'," + jsProps + "," + jBuild.endMap().toString();
        String finalScript = "ice.component.linkButton.updateProperties(" + params + ");";
        ScriptWriter.insertScript(facesContext, uiComponent, finalScript);
        writer.endElement("div");
    }
}

