/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.component.fileentry;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.icefaces.component.fileentry.FileEntry;
import org.icefaces.component.fileentry.FileEntryConfig;
import org.icefaces.component.fileentry.FileEntryEvent;
import org.icefaces.component.fileentry.FileEntryResults;
import org.icefaces.component.utils.Utils;
import org.icefaces.render.MandatoryResourceComponent;
import org.icefaces.util.EnvUtils;

@MandatoryResourceComponent(value="org.icefaces.component.fileentry.FileEntry")
public class FileEntryRenderer
extends Renderer {
    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIForm form = Utils.findParentForm(uiComponent);
        if (form == null) {
            throw new FacesException("FileEntry component must be contained in a form.");
        }
        FileEntry fileEntry = (FileEntry)uiComponent;
        String clientId = uiComponent.getClientId(facesContext);
        FileEntryConfig config = fileEntry.storeConfigForNextLifecycle(facesContext, clientId);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "clientId");
        boolean disabled = fileEntry.isDisabled();
        Utils.writeConcatenatedStyleClasses(writer, "ice-file-entry", fileEntry.getStyleClass());
        writer.writeAttribute("style", (Object)fileEntry.getStyle(), "style");
        writer.startElement("div", uiComponent);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"file", "type");
        writer.writeAttribute("id", (Object)config.getIdentifier(), "clientId");
        writer.writeAttribute("name", (Object)config.getIdentifier(), "clientId");
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"true", "disabled");
        }
        boolean ariaEnabled = EnvUtils.isAriaEnabled((FacesContext)facesContext);
        Integer tabindex = fileEntry.getTabindex();
        if (ariaEnabled && tabindex == null) {
            tabindex = 0;
        }
        if (tabindex != null) {
            writer.writeAttribute("tabindex", (Object)tabindex, "tabindex");
        }
        writer.endElement("input");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"inactive", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"progress-bar", null);
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        FileEntry fileEntry = (FileEntry)uiComponent;
        String clientId = uiComponent.getClientId(facesContext);
        FileEntryResults results = FileEntry.retrieveResultsFromEarlierInLifecycle(facesContext, clientId);
        if (results != null) {
            fileEntry.setResults(results);
        }
        boolean filesUploadedThisLifecycle = results != null;
        FileEntryEvent event = new FileEntryEvent((UIComponent)fileEntry, filesUploadedThisLifecycle);
        fileEntry.queueEvent(event);
        fileEntry.validateResults(facesContext, results);
    }
}

