/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.mallet;

import cc.mallet.pipe.Csv2FeatureVector;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.Target2Label;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Iterator;

public class InstanceListCreator {
    public static void main(String[] args) throws IOException {
        String inputDataFileName = args[0];
        String outputDataFileName = args[1];
        InstanceListCreator instanceListCreator = new InstanceListCreator();
        InstanceList instanceList = instanceListCreator.createInstanceList(new File(inputDataFileName));
        instanceList.save(new File(outputDataFileName));
    }

    public InstanceList createInstanceList(File dataFile) throws IOException {
        InstanceList instanceList = new InstanceList((Pipe)new SerialPipes(new Pipe[]{new Target2Label(), new Csv2FeatureVector()}));
        FileReader fileReader = new FileReader(dataFile);
        instanceList.addThruPipe((Iterator)new DataIterator(fileReader));
        ((Reader)fileReader).close();
        return instanceList;
    }

    public class DataIterator
    implements Iterator<Instance> {
        LineNumberReader reader;
        String currentLine;

        public DataIterator(Reader input) {
            this.reader = new LineNumberReader(input);
            try {
                this.currentLine = this.reader.readLine();
            }
            catch (IOException e) {
                throw new IllegalStateException();
            }
        }

        @Override
        public Instance next() {
            String data = null;
            String target = null;
            int split = this.currentLine.lastIndexOf(" ");
            data = this.currentLine.substring(0, split);
            target = this.currentLine.substring(split + 1);
            Instance carrier = new Instance((Object)data, (Object)target, null, null);
            try {
                this.currentLine = this.reader.readLine();
            }
            catch (IOException e) {
                throw new IllegalStateException();
            }
            return carrier;
        }

        @Override
        public boolean hasNext() {
            return this.currentLine != null;
        }

        @Override
        public void remove() {
            throw new IllegalStateException("This Iterator<Instance> does not support remove().");
        }
    }
}

