/*
 * Decompiled with CFR 0.152.
 */
package com.lexicalscope.jewel.cli;

import com.lexicalscope.jewel.cli.AbstractOptionSpecification;
import com.lexicalscope.jewel.cli.InvalidOptionSpecificationException;
import com.lexicalscope.jewel.cli.OptionAnnotationAdapter;
import com.lexicalscope.jewel.cli.ParsedOptionSummary;
import com.lexicalscope.jewel.cli.specification.ParsedOptionSpecification;
import java.util.ArrayList;
import java.util.List;

class ParsedOptionSpecificationImpl
extends AbstractOptionSpecification
implements ParsedOptionSpecification {
    private final OptionAnnotationAdapter optionAnnotation;

    ParsedOptionSpecificationImpl(OptionAnnotationAdapter annotation) {
        super(annotation);
        this.optionAnnotation = annotation;
        for (String longName : annotation.longName()) {
            if (!longName.trim().isEmpty()) continue;
            throw new InvalidOptionSpecificationException(String.format("option %s long name cannot be blank", this.getMethod()));
        }
    }

    @Override
    public List<String> getLongName() {
        return this.optionAnnotation.longName();
    }

    @Override
    public List<String> getShortNames() {
        return this.optionAnnotation.shortName();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> result = new ArrayList<String>(this.getShortNames());
        result.addAll(this.getLongName());
        return result;
    }

    @Override
    public boolean isHelpOption() {
        return this.optionAnnotation.helpRequest();
    }

    @Override
    public String getPattern() {
        return this.annotation.pattern();
    }

    @Override
    public boolean hasValue() {
        return !this.isBoolean();
    }

    @Override
    public final boolean isBoolean() {
        return this.getType().isAssignableFrom(Boolean.class) || this.getType().isAssignableFrom(Boolean.TYPE);
    }

    public String toString() {
        return new ParsedOptionSummary(this).toString();
    }

    @Override
    public boolean allowedValue(String value) {
        return value.matches(this.getPattern());
    }
}

