/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.pairing.cluster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.coreference.ae.MentionClusterCoreferenceAnnotator;
import org.apache.ctakes.coreference.ae.pairing.cluster.ClusterMentionPairer_ImplBase;
import org.apache.ctakes.coreference.util.ClusterUtils;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.log4j.Logger;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.tcas.Annotation;

public class HeadwordPairer
extends ClusterMentionPairer_ImplBase {
    private Map<String, Set<Markable>> headWordMarkables = null;

    @Override
    public void reset(JCas jcas) {
        super.reset(jcas);
        this.headWordMarkables = new HashMap<String, Set<Markable>>();
    }

    @Override
    public List<MentionClusterCoreferenceAnnotator.CollectionTextRelationIdentifiedAnnotationPair> getPairs(JCas jcas, Markable mention) {
        ArrayList<MentionClusterCoreferenceAnnotator.CollectionTextRelationIdentifiedAnnotationPair> pairs = new ArrayList<MentionClusterCoreferenceAnnotator.CollectionTextRelationIdentifiedAnnotationPair>();
        ConllDependencyNode headNode = DependencyUtility.getNominalHeadNode((JCas)jcas, (Annotation)mention);
        if (headNode == null) {
            Logger.getLogger(MentionClusterCoreferenceAnnotator.class).warn((Object)"There is a markable with no dependency node covering it.");
            return pairs;
        }
        String head = headNode.getCoveredText().toLowerCase();
        if (this.headWordMarkables.containsKey(head)) {
            Set<Markable> headSet = this.headWordMarkables.get(head);
            block0: for (CollectionTextRelation cluster : JCasUtil.select((JCas)jcas, CollectionTextRelation.class)) {
                Annotation mostRecent = ClusterUtils.getMostRecent((NonEmptyFSList)cluster.getMembers(), (Annotation)mention);
                if (mostRecent == null) continue;
                for (Markable m : JCasUtil.select((FSList)cluster.getMembers(), Markable.class)) {
                    if (headSet.contains(mostRecent)) {
                        pairs.add(new MentionClusterCoreferenceAnnotator.CollectionTextRelationIdentifiedAnnotationPair(cluster, (IdentifiedAnnotation)mention));
                        continue block0;
                    }
                    if (m != mostRecent) continue;
                    continue block0;
                }
            }
        } else {
            this.headWordMarkables.put(head, new HashSet());
        }
        this.headWordMarkables.get(head).add(mention);
        return pairs;
    }
}

