/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.features.salience;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.ctakes.typesystem.type.textspan.Paragraph;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class ClinicalFeatureExtractor
implements FeatureExtractor1<Markable> {
    public List<Feature> extract(JCas jcas, Markable markable) {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        List coveringPars = JCasUtil.selectCovering((JCas)jcas, Paragraph.class, (AnnotationFS)markable);
        List coveringSents = JCasUtil.selectCovering((JCas)jcas, Sentence.class, (AnnotationFS)markable);
        Sentence coveringSent = DependencyUtility.getSentence((JCas)jcas, (Annotation)markable);
        if (coveringPars.size() == 1 && coveringSents.size() == 1) {
            List parSents = JCasUtil.selectCovered(Sentence.class, (AnnotationFS)((AnnotationFS)coveringPars.get(0)));
            if (parSents.size() == 1) {
                feats.add(new Feature("ClinIsHeader", (Object)true));
            } else {
                int sentPos = 0;
                for (int i = 0; i < parSents.size(); ++i) {
                    if (parSents.get(i) != coveringSent) continue;
                    sentPos = i;
                    break;
                }
                if (sentPos < parSents.size() / 3) {
                    feats.add(new Feature("ClinSentPosBegin", (Object)true));
                } else if (sentPos > 2 * parSents.size() / 3) {
                    feats.add(new Feature("ClinSentPosEnd", (Object)true));
                } else {
                    feats.add(new Feature("ClinSentPosMiddle", (Object)true));
                }
            }
        }
        List events = JCasUtil.selectCovered(EventMention.class, (AnnotationFS)markable);
        EventMention longestEvent = null;
        for (EventMention event : events) {
            if (event.getTypeID() <= 0 || longestEvent != null && event.getEnd() - event.getBegin() <= longestEvent.getEnd() - longestEvent.getBegin()) continue;
            longestEvent = event;
        }
        if (longestEvent != null) {
            feats.add(new Feature("ClinSemType" + longestEvent.getClass().getSimpleName(), (Object)true));
        }
        return feats;
    }
}

