/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.features.cluster;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.util.ListIterable;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class MentionClusterSalienceFeaturesExtractor
implements RelationFeaturesExtractor<CollectionTextRelation, IdentifiedAnnotation>,
FeatureExtractor1<Markable> {
    public List<Feature> extract(JCas jCas, CollectionTextRelation cluster, IdentifiedAnnotation mention) throws AnalysisEngineProcessException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        double maxSalience = 0.0;
        for (Markable member : new ListIterable(cluster.getMembers())) {
            if (mention.getBegin() < member.getEnd()) break;
            if (!((double)member.getConfidence() > maxSalience)) continue;
            maxSalience = member.getConfidence();
        }
        feats.add(new Feature("MC_MAX_SALIENCE", (Object)maxSalience));
        return feats;
    }

    public List<Feature> extract(JCas jCas, Markable mention) throws CleartkExtractorException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        feats.add(new Feature("MC_MENTION_SALIENCE", (Object)Float.valueOf(mention.getConfidence())));
        return feats;
    }
}

