/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.dkpro.core.api.resources;

import de.tudarmstadt.ukp.dkpro.core.api.resources.CasConfigurableProviderBase;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class MappingProvider
extends CasConfigurableProviderBase<Map<String, String>> {
    public static final String BASE_TYPE = "baseType";
    private TypeSystem typeSystem;
    private boolean notFound = false;

    @Override
    public void configure(CAS aCas) {
        this.typeSystem = aCas.getTypeSystem();
        try {
            this.notFound = false;
            super.configure(aCas);
        }
        catch (AnalysisEngineProcessException e) {
            this.notFound = true;
        }
    }

    public Type getTagType(String aTag) {
        String type;
        if (this.notFound) {
            type = this.getDefault(BASE_TYPE);
        } else {
            type = (String)((Map)this.getResource()).get(aTag);
            if (type == null) {
                type = (String)((Map)this.getResource()).get("*");
            }
            if (type == null) {
                throw new IllegalStateException("No fallback (*) mapping defined!");
            }
        }
        Type uimaType = this.typeSystem.getType(type);
        if (uimaType == null) {
            throw new IllegalStateException("Type [" + type + "] mapped to tag [" + aTag + "] is not defined in type system");
        }
        return uimaType;
    }

    @Override
    protected Map<String, String> produceResource(URL aUrl) throws IOException {
        if (aUrl != null) {
            HashMap<String, String> mapping = new HashMap<String, String>();
            Properties props = PropertiesLoaderUtils.loadProperties((Resource)new UrlResource(aUrl));
            for (String key : props.stringPropertyNames()) {
                mapping.put(key.trim(), props.getProperty(key).trim());
            }
            return mapping;
        }
        return null;
    }
}

