/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.svmlight;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.cleartk.ml.Classifier;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.encoder.CleartkEncoderException;
import org.cleartk.ml.encoder.features.BooleanEncoder;
import org.cleartk.ml.encoder.features.FeatureEncoder;
import org.cleartk.ml.encoder.features.FeatureVectorFeaturesEncoder;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.features.NumberEncoder;
import org.cleartk.ml.encoder.features.StringEncoder;
import org.cleartk.ml.jar.DataWriter_ImplBase;
import org.cleartk.ml.jar.EncodingJarClassifierBuilder;
import org.cleartk.ml.util.featurevector.FeatureVector;

public abstract class SvmLightDataWriter_ImplBase<CLASSIFIER_BUILDER_TYPE extends EncodingJarClassifierBuilder<? extends Classifier<OUTCOME_TYPE>, FeatureVector, OUTCOME_TYPE, ENCODED_OUTCOME_TYPE>, OUTCOME_TYPE, ENCODED_OUTCOME_TYPE>
extends DataWriter_ImplBase<CLASSIFIER_BUILDER_TYPE, FeatureVector, OUTCOME_TYPE, ENCODED_OUTCOME_TYPE> {
    public SvmLightDataWriter_ImplBase(File outputDirectory) throws IOException {
        super(outputDirectory);
        FeatureVectorFeaturesEncoder myFeaturesEncoder = new FeatureVectorFeaturesEncoder();
        myFeaturesEncoder.addEncoder((FeatureEncoder)new NumberEncoder());
        myFeaturesEncoder.addEncoder((FeatureEncoder)new BooleanEncoder());
        myFeaturesEncoder.addEncoder((FeatureEncoder)new StringEncoder());
        this.setFeaturesEncoder((FeaturesEncoder)myFeaturesEncoder);
    }

    protected abstract String outcomeToString(ENCODED_OUTCOME_TYPE var1);

    public void writeEncoded(FeatureVector features, ENCODED_OUTCOME_TYPE outcome) throws CleartkProcessingException {
        StringBuffer output = new StringBuffer();
        output.append(this.outcomeToString(outcome));
        for (FeatureVector.Entry entry : features) {
            if (Double.isInfinite(entry.value) || Double.isNaN(entry.value)) {
                throw CleartkEncoderException.invalidFeatureVectorValue((int)entry.index, (double)entry.value);
            }
            output.append(String.format(Locale.US, " %d:%.7f", entry.index, entry.value));
        }
        this.trainingDataWriter.println(output);
    }
}

