/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.semil;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.ctakes.ytex.kernel.FileUtil;
import org.apache.ctakes.ytex.kernel.InstanceData;
import org.apache.ctakes.ytex.kernel.KernelUtil;
import org.apache.ctakes.ytex.kernel.SparseData;
import org.apache.ctakes.ytex.kernel.SparseDataFormatter;
import org.apache.ctakes.ytex.kernel.SparseDataFormatterFactory;
import org.apache.ctakes.ytex.svmlight.SVMLightFormatterFactory;

public class SemiLFormatterFactory
implements SparseDataFormatterFactory {
    private KernelUtil kernelUtil;

    @Override
    public SparseDataFormatter getFormatter() {
        return new SemiLDataFormatter(this.getKernelUtil());
    }

    public KernelUtil getKernelUtil() {
        return this.kernelUtil;
    }

    public void setKernelUtil(KernelUtil kernelUtil) {
        this.kernelUtil = kernelUtil;
    }

    public static class SemiLDataFormatter
    extends SVMLightFormatterFactory.SVMLightFormatter {
        protected InstanceData instanceLabel = null;
        NumberFormat semilNumberFormat = new DecimalFormat("#.######");

        public SemiLDataFormatter(KernelUtil kernelUtil) {
            super(kernelUtil);
        }

        protected void exportData(SparseData sparseData, String label, Integer run, Integer fold) throws IOException {
            this.exportAttributeNames(sparseData, label, run, fold);
            String filename = FileUtil.getScopedFileName(this.outdir, label, run, fold, "data.txt");
            this.exportSparseMatrix(filename, sparseData);
        }

        @Override
        public void exportFold(SparseData sparseData, SortedMap<Long, String> instanceClassMap, boolean train, String label, Integer run, Integer fold) throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void exportLabel(String lblFilename, SortedMap<Long, Integer> mapInstanceIdToClass) throws IOException {
            BufferedWriter wLabel = null;
            try {
                wLabel = new BufferedWriter(new FileWriter(lblFilename));
                for (Map.Entry<Long, Integer> entryInstanceIdToClass : mapInstanceIdToClass.entrySet()) {
                    wLabel.write(Integer.toString(entryInstanceIdToClass.getValue()));
                    wLabel.write("\n");
                }
            }
            finally {
                if (wLabel != null) {
                    try {
                        wLabel.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SortedMap<Long, Integer> getTrainingClassMap(String idFilename, SortedMap<Long, String> trainInstanceClassMap, SortedMap<Long, String> testInstanceClassMap, Map<String, Integer> classToIndexMap, SortedSet<Long> instanceIds) throws IOException {
            TreeMap<Long, Integer> mapInstanceIdToClass = new TreeMap<Long, Integer>();
            BufferedWriter wId = null;
            try {
                wId = new BufferedWriter(new FileWriter(idFilename));
                for (Long instanceId : instanceIds) {
                    int classIdTrain = 0;
                    String classNameTrain = "0";
                    if (trainInstanceClassMap.containsKey(instanceId)) {
                        classNameTrain = (String)trainInstanceClassMap.get(instanceId);
                        classIdTrain = classToIndexMap.get(classNameTrain);
                    }
                    mapInstanceIdToClass.put(instanceId, classIdTrain);
                    if (testInstanceClassMap != null && testInstanceClassMap.containsKey(instanceId)) {
                        classNameTrain = (String)testInstanceClassMap.get(instanceId);
                    }
                    wId.write(Long.toString(instanceId));
                    wId.write("\t");
                    wId.write(trainInstanceClassMap.containsKey(instanceId) ? "1" : "0");
                    wId.write("\t");
                    wId.write(classNameTrain);
                    wId.write("\n");
                }
            }
            finally {
                if (wId != null) {
                    try {
                        wId.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return mapInstanceIdToClass;
        }

        @Override
        public void initializeExport(InstanceData instanceLabel, Properties properties, SparseData sparseData) throws IOException {
            super.initializeExport(instanceLabel, properties, sparseData);
            this.instanceLabel = instanceLabel;
            if (properties.getProperty("scope") == null || properties.getProperty("scope").length() == 0) {
                this.exportData(sparseData, null, null, null);
            }
        }

        @Override
        public void initializeFold(SparseData sparseData, String label, Integer run, Integer fold, SortedMap<Boolean, SortedMap<Long, String>> foldInstanceLabelMap) throws IOException {
            if ("fold".equals(this.exportProperties.getProperty("scope"))) {
                this.exportData(sparseData, label, run, fold);
            }
            String labelFileName = FileUtil.getScopedFileName(this.outdir, label, run, fold, "label.txt");
            String idFileName = FileUtil.getScopedFileName(this.outdir, label, run, fold, "class.txt");
            SortedMap<Long, Integer> trainInstanceIdToClass = this.getTrainingClassMap(idFileName, (SortedMap)foldInstanceLabelMap.get(true), (SortedMap)foldInstanceLabelMap.get(false), (Map)this.labelToClassIndexMap.get(label), sparseData.getInstanceIds());
            this.exportLabel(labelFileName, trainInstanceIdToClass);
        }

        @Override
        public void initializeLabel(String label, SortedMap<Integer, SortedMap<Integer, SortedMap<Boolean, SortedMap<Long, String>>>> labelInstances, Properties properties, SparseData sparseData) throws IOException {
            super.initializeLabel(label, labelInstances, properties, sparseData);
            if ("label".equals(this.exportProperties.getProperty("scope"))) {
                this.exportData(sparseData, label, null, null);
            }
        }

        @Override
        protected void fillLabelToClassIndexMap(Map<String, SortedSet<String>> labelToClassMap) {
            this.kernelUtil.fillLabelToClassToIndexMap(labelToClassMap, this.labelToClassIndexMap);
            this.updateLabelClassMapTransductive();
        }
    }
}

