/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.libsvm;

import com.google.common.collect.BiMap;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.ctakes.ytex.kernel.FileUtil;
import org.apache.ctakes.ytex.kernel.InstanceData;
import org.apache.ctakes.ytex.kernel.KernelContextHolder;
import org.apache.ctakes.ytex.kernel.KernelUtil;
import org.apache.ctakes.ytex.kernel.dao.KernelEvaluationDao;
import org.apache.ctakes.ytex.libsvm.LibSVMGramMatrixExporter;
import org.apache.ctakes.ytex.libsvm.LibSVMUtil;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;

public class LibSVMGramMatrixExporterImpl
implements LibSVMGramMatrixExporter {
    private JdbcTemplate jdbcTemplate = null;
    private KernelEvaluationDao kernelEvaluationDao = null;
    private KernelUtil kernelUtil;
    private LibSVMUtil libsvmUtil;
    private PlatformTransactionManager transactionManager;

    public static void main(String[] args) throws IOException {
        Options options = new Options();
        OptionBuilder.withArgName((String)"prop");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"property file with queries and other kernel parameters");
        options.addOption(OptionBuilder.create((String)"prop"));
        try {
            GnuParser parser = new GnuParser();
            CommandLine line = parser.parse(options, args);
            LibSVMGramMatrixExporter exporter = (LibSVMGramMatrixExporter)KernelContextHolder.getApplicationContext().getBean("libSVMGramMatrixExporter");
            exporter.exportGramMatrix(FileUtil.loadProperties(line.getOptionValue("prop"), true));
        }
        catch (ParseException pe) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java " + LibSVMGramMatrixExporterImpl.class.getName() + " export gram matrix in libsvm format", options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportFold(double[][] gramMatrix, Map<Boolean, SortedMap<Long, String>> instanceIdToClassMap, boolean train, Map<Long, Integer> mapInstanceIdToIndex, String filePrefix, Map<String, Integer> mapClassToIndex) throws IOException {
        String fileName = filePrefix + "_data.txt";
        String idFileName = filePrefix + "_id.txt";
        BufferedWriter w = null;
        BufferedWriter wId = null;
        ArrayList<Long> colInstanceIds = new ArrayList<Long>(instanceIdToClassMap.get(true).keySet());
        Collections.sort(colInstanceIds);
        SortedMap<Long, String> rowInstanceToClassMap = instanceIdToClassMap.get(train);
        try {
            w = new BufferedWriter(new FileWriter(fileName));
            wId = new BufferedWriter(new FileWriter(idFileName));
            int rowIndex = 0;
            for (Map.Entry<Long, String> instanceClass : rowInstanceToClassMap.entrySet()) {
                String classId = instanceClass.getValue();
                long rowInstanceId = instanceClass.getKey();
                int rowInstanceIndex = mapInstanceIdToIndex.get(rowInstanceId);
                w.write(mapClassToIndex.get(classId).toString());
                w.write("\t");
                w.write("0:");
                w.write(Integer.toString(rowIndex + 1));
                for (int columnIndex = 0; columnIndex < colInstanceIds.size(); ++columnIndex) {
                    long colInstanceId = (Long)colInstanceIds.get(columnIndex);
                    int colInstanceIndex = mapInstanceIdToIndex.get(colInstanceId);
                    w.write("\t");
                    w.write(Integer.toString(columnIndex + 1));
                    w.write(":");
                    w.write(Double.toString(gramMatrix[rowInstanceIndex][colInstanceIndex]));
                }
                w.write("\n");
                ++rowIndex;
                wId.write(Long.toString(rowInstanceId));
                wId.write("\n");
            }
        }
        finally {
            if (w != null) {
                w.close();
            }
            if (wId != null) {
                wId.close();
            }
        }
    }

    private void exportGramMatrices(String name, String experiment, double param1, String param2, String scope, String splitName, String outdir, InstanceData instanceData, Map<String, BiMap<String, Integer>> labelToClassIndexMap) throws IOException {
        double[][] gramMatrix = null;
        TreeSet<Long> instanceIds = new TreeSet<Long>();
        HashMap<Long, Integer> mapInstanceIdToIndex = new HashMap<Long, Integer>();
        if ((scope == null || scope.length() == 0) && (gramMatrix = this.loadGramMatrix(name, experiment, param1, param2, splitName, null, 0, 0, instanceData, instanceIds, mapInstanceIdToIndex)) == null) {
            return;
        }
        for (String label : instanceData.getLabelToInstanceMap().keySet()) {
            if ("label".equals(scope) && (gramMatrix = this.loadGramMatrix(name, experiment, param1, param2, splitName, label, 0, 0, instanceData, instanceIds, mapInstanceIdToIndex)) == null) {
                return;
            }
            this.kernelUtil.exportClassIds(outdir, (Map)labelToClassIndexMap.get(label), label);
            Iterator iterator = ((SortedMap)instanceData.getLabelToInstanceMap().get(label)).keySet().iterator();
            while (iterator.hasNext()) {
                int run = (Integer)iterator.next();
                Iterator iterator2 = ((SortedMap)((SortedMap)instanceData.getLabelToInstanceMap().get(label)).get(run)).keySet().iterator();
                while (iterator2.hasNext()) {
                    int fold = (Integer)iterator2.next();
                    if ("fold".equals(scope)) {
                        gramMatrix = this.loadGramMatrix(name, experiment, param1, param2, splitName, label, run, fold, instanceData, instanceIds, mapInstanceIdToIndex);
                    }
                    if (gramMatrix == null) continue;
                    Map foldMap = (Map)((SortedMap)((SortedMap)instanceData.getLabelToInstanceMap().get(label)).get(run)).get(fold);
                    this.exportFold(gramMatrix, foldMap, true, mapInstanceIdToIndex, FileUtil.getDataFilePrefix(outdir, label, run, fold, true), (Map)labelToClassIndexMap.get(label));
                    this.exportFold(gramMatrix, foldMap, false, mapInstanceIdToIndex, FileUtil.getDataFilePrefix(outdir, label, run, fold, false), (Map)labelToClassIndexMap.get(label));
                }
            }
        }
    }

    @Override
    public void exportGramMatrix(Properties props) throws IOException {
        String name = props.getProperty("org.apache.ctakes.ytex.corpusName");
        String experiment = props.getProperty("org.apache.ctakes.ytex.experiment");
        String param2 = props.getProperty("org.apache.ctakes.ytex.param2");
        double param1 = Double.parseDouble(props.getProperty("org.apache.ctakes.ytex.param1", "0"));
        String scope = props.getProperty("scope");
        InstanceData instanceData = this.getKernelUtil().loadInstances(props.getProperty("instanceClassQuery"));
        String splitName = props.getProperty("org.apache.ctakes.ytex.splitName");
        String outdir = props.getProperty("outdir");
        HashMap<String, BiMap<String, Integer>> labelToClassIndexMap = new HashMap<String, BiMap<String, Integer>>();
        this.kernelUtil.fillLabelToClassToIndexMap(instanceData.getLabelToClassMap(), labelToClassIndexMap);
        this.exportGramMatrices(name, experiment, param1, param2, scope, splitName, outdir, instanceData, labelToClassIndexMap);
    }

    public DataSource getDataSource() {
        return this.jdbcTemplate.getDataSource();
    }

    public KernelEvaluationDao getKernelEvaluationDao() {
        return this.kernelEvaluationDao;
    }

    public KernelUtil getKernelUtil() {
        return this.kernelUtil;
    }

    public LibSVMUtil getLibsvmUtil() {
        return this.libsvmUtil;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    private double[][] loadGramMatrix(String name, String experiment, double param1, String param2, String splitName, String label, int run, int fold, InstanceData instanceData, SortedSet<Long> instanceIds, Map<Long, Integer> mapInstanceIdToIndex) {
        instanceIds.clear();
        mapInstanceIdToIndex.clear();
        instanceIds.addAll(instanceData.getAllInstanceIds(label, run, fold));
        int index = 0;
        Iterator iterator = instanceIds.iterator();
        while (iterator.hasNext()) {
            long instanceId = (Long)iterator.next();
            mapInstanceIdToIndex.put(instanceId, index++);
        }
        double[][] gramMatrix = this.kernelUtil.loadGramMatrix(instanceIds, name, splitName, experiment, label, run, fold, param1, param2);
        return gramMatrix;
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setKernelEvaluationDao(KernelEvaluationDao kernelEvaluationDao) {
        this.kernelEvaluationDao = kernelEvaluationDao;
    }

    public void setKernelUtil(KernelUtil kernelUtil) {
        this.kernelUtil = kernelUtil;
    }

    public void setLibsvmUtil(LibSVMUtil libsvmUtil) {
        this.libsvmUtil = libsvmUtil;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

