/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.evaluator;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.evaluator.Kernel;
import org.apache.ctakes.ytex.kernel.tree.Node;

public class NormKernel
implements Kernel {
    private static final Log log = LogFactory.getLog(NormKernel.class);
    private Cache normCache;
    private CacheManager cacheManager;
    private Kernel delegateKernel;
    private boolean cacheNorm = true;

    public boolean isCacheNorm() {
        return this.cacheNorm;
    }

    public void setCacheNorm(boolean cacheNorm) {
        this.cacheNorm = cacheNorm;
    }

    public NormKernel(Kernel delegateKernel) {
        this.delegateKernel = delegateKernel;
    }

    public NormKernel() {
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public Kernel getDelegateKernel() {
        return this.delegateKernel;
    }

    public void setDelegateKernel(Kernel delegateKernel) {
        this.delegateKernel = delegateKernel;
    }

    public double getNorm(Object o1) {
        Double norm = null;
        if (o1 != null) {
            if (o1 instanceof Node) {
                norm = ((Node)o1).getNorm();
            } else if (this.isCacheNorm()) {
                Element cachedNorm = null;
                cachedNorm = this.normCache.get(o1);
                if (cachedNorm != null) {
                    norm = (Double)cachedNorm.getValue();
                }
            }
            if (norm == null) {
                norm = Math.sqrt(this.delegateKernel.evaluate(o1, o1));
            }
            if (o1 instanceof Node) {
                ((Node)o1).setNorm(norm);
            } else if (this.isCacheNorm()) {
                this.normCache.put(new Element(o1, (Object)norm));
            }
        }
        return norm;
    }

    @Override
    public double evaluate(Object o1, Object o2) {
        double d = 0.0;
        if (o1 == null || o2 == null) {
            d = 0.0;
        } else {
            double norm1 = this.getNorm(o1);
            double norm2 = this.getNorm(o2);
            if (norm1 != 0.0 && norm2 != 0.0) {
                d = this.delegateKernel.evaluate(o1, o2) / (norm1 * norm2);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("K<" + o1 + "," + o2 + "> = " + d));
        }
        return d;
    }

    public void init() {
        this.normCache = this.cacheManager.getCache("normCache");
    }
}

