/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel;

import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.FileUtil;
import org.apache.ctakes.ytex.kernel.KernelUtil;
import org.apache.ctakes.ytex.kernel.SparseData;
import org.apache.ctakes.ytex.kernel.SparseDataFormatter;
import org.apache.ctakes.ytex.kernel.SparseDataFormatterFactory;
import org.apache.ctakes.ytex.semil.SemiLFormatterFactory;

public class SVMLinFormatterFactory
implements SparseDataFormatterFactory {
    private KernelUtil kernelUtil;

    @Override
    public SparseDataFormatter getFormatter() {
        return new SVMLinDataFormatter(this.kernelUtil);
    }

    public KernelUtil getKernelUtil() {
        return this.kernelUtil;
    }

    public void setKernelUtil(KernelUtil kernelUtil) {
        this.kernelUtil = kernelUtil;
    }

    public static String formatWeightKey(String label, String className) {
        return (Strings.isNullOrEmpty((String)label) ? "" : "label" + label + "_") + "class" + className;
    }

    public static class SVMLinDataFormatter
    extends SemiLFormatterFactory.SemiLDataFormatter {
        private static final Log log = LogFactory.getLog(SVMLinDataFormatter.class);

        public SVMLinDataFormatter(KernelUtil kernelUtil) {
            super(kernelUtil);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void exportData(SparseData sparseData, String label, Integer run, Integer fold) throws IOException {
            this.exportAttributeNames(sparseData, label, run, fold);
            String filename = FileUtil.getScopedFileName(this.outdir, label, run, fold, "data.txt");
            try (BufferedWriter wData = null;){
                wData = new BufferedWriter(new FileWriter(filename));
                Iterator iterator = sparseData.getInstanceIds().iterator();
                while (iterator.hasNext()) {
                    long instanceId = (Long)iterator.next();
                    SortedMap<Integer, Double> instanceValues = this.getSparseLineValues(sparseData, this.numericAttributeMap, this.nominalAttributeMap, instanceId);
                    this.writeLibsvmLine(wData, instanceValues);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void exportOneAgainstAllCodes(String label, Integer run, Integer fold, SortedMap<Long, Integer> trainInstanceIdToClass, Map<Integer, String> codeToClassNameMap) throws IOException {
            String classFileName = FileUtil.getScopedFileName(this.outdir, label, run, fold, "code.properties");
            TreeSet<Integer> classIds = new TreeSet<Integer>();
            classIds.addAll(trainInstanceIdToClass.values());
            classIds.remove(0);
            if (classIds.size() < 2) {
                log.warn((Object)("<2 classes, skipping export for label " + label + " run " + run + " fold " + fold));
                return;
            }
            Properties props = new Properties();
            StringBuilder bCodeList = new StringBuilder();
            int code = 1;
            Integer[] classIdArray = classIds.toArray(new Integer[0]);
            for (int i = 0; i < classIdArray.length; ++i) {
                int classId = classIdArray[i];
                String className = codeToClassNameMap.get(classId);
                TreeMap<Long, Integer> mapRecodedInstanceIdToClass = new TreeMap<Long, Integer>();
                for (Map.Entry<Long, Integer> instanceIdToClassEntry : trainInstanceIdToClass.entrySet()) {
                    int trainClassId = instanceIdToClassEntry.getValue();
                    int codedClassId = 0;
                    if (trainClassId == classId) {
                        codedClassId = 1;
                    } else if (trainClassId != 0) {
                        codedClassId = -1;
                    }
                    mapRecodedInstanceIdToClass.put(instanceIdToClassEntry.getKey(), codedClassId);
                }
                String labelFileBaseName = FileUtil.getScopedFileName(this.outdir, label, run, fold, "class" + codeToClassNameMap.get(classId) + ".txt");
                this.exportLabel(labelFileBaseName, mapRecodedInstanceIdToClass);
                props.setProperty(labelFileBaseName + ".class", Integer.toString(classId));
                props.setProperty(labelFileBaseName + ".className", className);
                props.setProperty("classrel", SVMLinFormatterFactory.formatWeightKey(label, className));
                bCodeList.append(labelFileBaseName).append(",");
                if (classIdArray.length == 2) {
                    props.setProperty("classOther", Integer.toString(classIdArray[1]));
                    props.setProperty("classOtherName", codeToClassNameMap.get(classIdArray[1]));
                    break;
                }
                ++code;
            }
            props.setProperty("codes", bCodeList.toString());
            Writer w = null;
            try {
                w = new BufferedWriter(new FileWriter(classFileName));
                props.store(w, "oneAgainstAll");
            }
            finally {
                if (w != null) {
                    try {
                        w.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        @Override
        public void initializeFold(SparseData sparseData, String label, Integer run, Integer fold, SortedMap<Boolean, SortedMap<Long, String>> foldInstanceLabelMap) throws IOException {
            if ("fold".equals(this.exportProperties.getProperty("scope"))) {
                this.exportData(sparseData, label, run, fold);
            }
            String idFileName = FileUtil.getScopedFileName(this.outdir, label, run, fold, "id.txt");
            SortedMap<Long, Integer> trainInstanceIdToClass = super.getTrainingClassMap(idFileName, (SortedMap)foldInstanceLabelMap.get(true), (SortedMap)foldInstanceLabelMap.get(false), (Map)this.labelToClassIndexMap.get(label), sparseData.getInstanceIds());
            this.exportOneAgainstAllCodes(label, run, fold, trainInstanceIdToClass, (Map<Integer, String>)((BiMap)this.labelToClassIndexMap.get(label)).inverse());
        }
    }
}

