/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.jdl;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.sql.SQLException;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.jdl.data.base.JdlConnection;
import org.apache.ctakes.jdl.data.loader.CsvLoader;
import org.apache.ctakes.jdl.data.loader.XmlLoader;
import org.apache.ctakes.jdl.data.xml.DomUtil;
import org.apache.ctakes.jdl.data.xml.SchemaUtil;
import org.apache.ctakes.jdl.data.xml.Validation;
import org.apache.ctakes.jdl.data.xml.jaxb.ObjectFactoryUtil;
import org.apache.ctakes.jdl.schema.xdl.JdbcType;
import org.apache.ctakes.jdl.schema.xdl.LoadType;

public class AppJdl {
    private static final Log log = LogFactory.getLog(AppJdl.class);
    private String srcConn;
    private String srcData;
    private String srcLoad;
    public static final URL XSD = AppJdl.class.getResource("/org/apache/ctakes/jdl/xdl.xsd");

    public AppJdl(String srcConn, String srcData, String srcLoad) {
        this.srcConn = srcConn;
        this.srcData = srcData;
        this.srcLoad = srcLoad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        Validation validation = new Validation(SchemaUtil.urlToSchema(XSD), this.srcConn);
        if (validation.succeed()) {
            validation.setDocument(this.srcLoad);
            if (validation.succeed()) {
                JdlConnection jdlConnection = null;
                try {
                    LoadType.Xml xml;
                    JdbcType jdbc = ObjectFactoryUtil.getJdbcTypeBySrcXml(this.srcConn);
                    LoadType load = ObjectFactoryUtil.getLoadTypeBySrcXml(this.srcLoad);
                    jdlConnection = new JdlConnection(jdbc);
                    LoadType.Csv csv = load.getCsv();
                    if (csv != null) {
                        try {
                            CsvLoader csvLoader = new CsvLoader(csv, new File(this.srcData));
                            csvLoader.dataInsert(jdlConnection);
                        }
                        catch (FileNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if ((xml = load.getXml()) == null) return;
                    XmlLoader xPathParsing = new XmlLoader(xml, DomUtil.srcToDocument(this.srcData));
                    xPathParsing.dataInsert(jdlConnection);
                    return;
                }
                catch (JAXBException e) {
                    e.printStackTrace();
                    return;
                }
                finally {
                    try {
                        if (jdlConnection != null) {
                            jdlConnection.closeConnection();
                        }
                    }
                    catch (SQLException e) {
                        log.error((Object)"closing connection", (Throwable)e);
                    }
                }
            }
            System.err.println(validation.getError());
            return;
        }
        System.err.println(validation.getError());
    }
}

