/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.corpus.conll2005;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.srl.type.Argument;
import org.cleartk.srl.type.Predicate;
import org.cleartk.srl.type.SemanticArgument;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;

public class Conll2005Writer
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="outputFile", mandatory=true, description="the path where the CoNLL-2005-formatted text should be written")
    private File outputFile;
    public static final String PARAM_OUTPUT_FILE = "outputFile";
    private PrintWriter output;
    private boolean first;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.output = new PrintWriter(this.outputFile);
            this.first = true;
        }
        catch (FileNotFoundException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Collection sentences = JCasUtil.select((JCas)jCas, Sentence.class);
        for (Sentence sentence : sentences) {
            if (this.first) {
                this.first = false;
            } else {
                this.output.println();
            }
            ArrayList<PredicateWriter> predicateWriters = new ArrayList<PredicateWriter>();
            for (Predicate predicate : JCasUtil.selectCovered((JCas)jCas, Predicate.class, (AnnotationFS)sentence)) {
                predicateWriters.add(new PredicateWriter(jCas, predicate));
            }
            for (Token token : JCasUtil.selectCovered((JCas)jCas, Token.class, (AnnotationFS)sentence)) {
                Conll05Line line = new Conll05Line();
                for (PredicateWriter predicateWriter : predicateWriters) {
                    predicateWriter.write(token, line);
                }
                this.output.println(line.evalString());
            }
        }
        this.output.flush();
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        this.output.close();
        super.collectionProcessComplete();
    }

    private static class ArgumentWriter {
        String label;
        String feature;
        String preposition;
        List<Token> tokens;

        ArgumentWriter(JCas jCas, SemanticArgument arg) {
            this.label = arg.getLabel();
            this.feature = arg.getFeature();
            this.preposition = arg.getPreposition();
            this.tokens = JCasUtil.selectCovered((JCas)jCas, Token.class, (AnnotationFS)arg.getAnnotation());
        }

        String getStartString(Token token) {
            if (token == this.tokens.get(0)) {
                return "(" + this.getFullLabel();
            }
            return "";
        }

        String getEndString(Token token) {
            if (token == this.tokens.get(this.tokens.size() - 1)) {
                return ")";
            }
            return "";
        }

        String getFullLabel() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.label);
            if (this.feature != null) {
                buffer.append("-" + this.feature);
            }
            if (this.preposition != null) {
                buffer.append("-" + this.preposition);
            }
            return buffer.toString();
        }
    }

    private static class PredicateWriter {
        String baseform;
        Integer frameset;
        Token token;
        List<ArgumentWriter> argumentWriters;

        PredicateWriter(JCas jCas, Predicate predicate) {
            this.token = (Token)JCasUtil.selectCovered((JCas)jCas, Token.class, (AnnotationFS)predicate.getAnnotation()).get(0);
            this.baseform = predicate.getBaseForm();
            this.frameset = 1;
            Collection allArgs = JCasUtil.select((FSArray)predicate.getArguments(), Argument.class);
            this.argumentWriters = new ArrayList<ArgumentWriter>();
            for (Argument arg : allArgs) {
                if (!(arg instanceof SemanticArgument)) continue;
                this.argumentWriters.add(new ArgumentWriter(jCas, (SemanticArgument)arg));
            }
        }

        void write(Token tok, Conll05Line line) {
            if (this.token.equals((Object)tok)) {
                line.setPredicateBaseform(this.baseform);
                line.setPredicateFrameset(this.frameset);
            }
            line.addArgumentRole(this.getArgumentsString(tok));
        }

        String getArgumentsString(Token tok) {
            StringBuffer buffer = new StringBuffer();
            for (ArgumentWriter argumentWriter : this.argumentWriters) {
                buffer.append(argumentWriter.getStartString(tok));
            }
            buffer.append("*");
            for (ArgumentWriter argumentWriter : this.argumentWriters) {
                buffer.append(argumentWriter.getEndString(tok));
            }
            return buffer.toString();
        }
    }

    private static class Conll05Line {
        String predicateBaseform = "-";
        List<String> argumentRoles = new ArrayList<String>();

        public String evalString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.predicateBaseform);
            for (String argumentRole : this.argumentRoles) {
                buffer.append("\t");
                buffer.append(argumentRole);
            }
            return buffer.toString();
        }

        public void setPredicateFrameset(Integer predicateFrameset) {
        }

        public void setPredicateBaseform(String predicateBaseform) {
            this.predicateBaseform = predicateBaseform == null ? "-" : predicateBaseform;
        }

        public void addArgumentRole(String argumentRole) {
            this.argumentRoles.add(argumentRole);
        }
    }
}

