/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.report.claim;

import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;
import org.apache.rat.api.RatException;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.report.claim.AbstractClaimReporter;
import org.apache.rat.report.claim.ClaimStatistic;

public class ClaimAggregator
extends AbstractClaimReporter {
    private final ClaimStatistic statistic;

    public ClaimAggregator(ClaimStatistic statistic) {
        this.statistic = statistic;
    }

    @Override
    protected void handleDocumentCategoryClaim(Document.Type documentType) {
        this.statistic.incCounter(documentType, 1);
    }

    @Override
    protected void handleApprovedLicenseClaim(MetaData metadata) {
        this.statistic.incCounter(ClaimStatistic.Counter.APPROVED, (int)metadata.approvedLicenses().count());
        this.statistic.incCounter(ClaimStatistic.Counter.UNAPPROVED, (int)metadata.unapprovedLicenses().count());
    }

    @Override
    protected void handleLicenseClaim(ILicense license) {
        String category = license.getLicenseFamily().getFamilyCategory();
        if (category.equals(ILicenseFamily.UNKNOWN.getFamilyCategory())) {
            this.statistic.incCounter(ClaimStatistic.Counter.UNKNOWN, 1);
        }
        this.statistic.incLicenseCategoryCount(category, 1);
        this.statistic.incLicenseNameCount(license.getName(), 1);
    }

    @Override
    public void endReport() throws RatException {
        super.endReport();
    }
}

