/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db.load;

import org.apache.cayenne.configuration.ConfigurationNameMapper;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.event.DataMapEvent;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectSaver;
import org.apache.cayenne.resource.Resource;

public class DbImportProjectSaver
implements ProjectSaver {
    private ConfigurationNameMapper nameMapper;
    private ProjectController projectController;

    public DbImportProjectSaver(@Inject ProjectController projectController, @Inject ConfigurationNameMapper nameMapper) {
        this.projectController = projectController;
        this.nameMapper = nameMapper;
    }

    @Override
    public String getSupportedVersion() {
        return "-1";
    }

    @Override
    public void save(Project project) {
        DataMap dataMap = (DataMap)project.getRootNode();
        if (this.projectController.getCurrentDataMap() != null) {
            this.projectController.fireDataMapEvent(new DataMapEvent((Object)Application.getFrame(), dataMap, 3));
            this.projectController.fireDataMapEvent(new DataMapEvent((Object)Application.getFrame(), dataMap, 2));
        } else {
            DataChannelDescriptor currentDomain = (DataChannelDescriptor)this.projectController.getProject().getRootNode();
            Resource baseResource = currentDomain.getConfigurationSource();
            if (baseResource != null) {
                Resource dataMapResource = baseResource.getRelativeResource(this.nameMapper.configurationLocation(dataMap));
                dataMap.setConfigurationSource(dataMapResource);
            }
            this.projectController.addDataMap(Application.getFrame(), dataMap);
        }
    }

    @Override
    public void saveAs(Project project, Resource baseDirectory) {
        this.save(project);
    }
}

