/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

public class DecoratedMessager {
    private final Messager messager;
    private final Set<MessageId> emittedMessages = new HashSet<MessageId>();

    public DecoratedMessager(Messager messager) {
        this.messager = messager;
    }

    public void warn(String template, Object ... arguments) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format(template, arguments));
    }

    public void warn(Element element, String template, Object ... arguments) {
        this.message(Diagnostic.Kind.WARNING, element, template, arguments);
    }

    public void error(Element element, String template, Object ... arguments) {
        this.message(Diagnostic.Kind.ERROR, element, template, arguments);
    }

    private void message(Diagnostic.Kind level, Element element, String template, Object[] arguments) {
        if (this.emittedMessages.add(new MessageId(level, element, template, arguments))) {
            this.messager.printMessage(level, DecoratedMessager.formatLocation(element) + String.format(template, arguments), element);
        }
    }

    private static String formatLocation(Element element) {
        switch (element.getKind()) {
            case CLASS: 
            case INTERFACE: {
                return String.format("[%s] ", element.getSimpleName());
            }
            case FIELD: 
            case METHOD: 
            case CONSTRUCTOR: {
                return String.format("[%s.%s] ", element.getEnclosingElement().getSimpleName(), element.getSimpleName());
            }
            case PARAMETER: {
                Element method = element.getEnclosingElement();
                Element type = method.getEnclosingElement();
                return String.format("[%s.%s, parameter %s] ", type.getSimpleName(), method.getSimpleName(), element.getSimpleName());
            }
        }
        return String.format("[%s] ", element);
    }

    private static class MessageId {
        private final Diagnostic.Kind level;
        private final Element element;
        private final String template;
        private final Object[] arguments;

        private MessageId(Diagnostic.Kind level, Element element, String template, Object[] arguments) {
            this.level = level;
            this.element = element;
            this.template = template;
            this.arguments = arguments;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof MessageId) {
                MessageId that = (MessageId)other;
                return this.level == that.level && Objects.equals(this.element, that.element) && Objects.equals(this.template, that.template) && Arrays.deepEquals(this.arguments, that.arguments);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.level, this.element, this.template, Arrays.hashCode(this.arguments)});
        }
    }
}

