/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.msg.jdk;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cassandra.cdc.msg.CdcEvent;
import org.apache.cassandra.cdc.msg.Value;
import org.apache.cassandra.cdc.msg.jdk.Column;
import org.apache.cassandra.cdc.msg.jdk.JdkMessageConverter;
import org.apache.cassandra.cdc.msg.jdk.RangeTombstoneMsg;
import org.apache.cassandra.spark.data.CassandraTypes;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.utils.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class CdcMessage {
    private final String keyspace;
    private final String table;
    private final List<Column> partitionKeys;
    private final List<Column> clusteringKeys;
    private final List<Column> staticColumns;
    private final List<Column> valueColumns;
    private final long maxTimestampMicros;
    private final CdcEvent.Kind operationType;
    private final Map<String, Column> columns;
    private final List<RangeTombstoneMsg> rangeTombstoneList;
    @Nullable
    private final CdcEvent.TimeToLive ttl;
    @Nullable
    private final Map<String, List<Object>> complexCellDeletion;

    public CdcMessage(JdkMessageConverter messageConverter, CdcEvent event) {
        this(event.keyspace, event.table, CdcMessage.toColumns(messageConverter, event.getPartitionKeys()), CdcMessage.toColumns(messageConverter, event.getClusteringKeys()), CdcMessage.toColumns(messageConverter, event.getStaticColumns()), CdcMessage.toColumns(messageConverter, event.getValueColumns()), event.getTimestamp(TimeUnit.MICROSECONDS), event.getKind(), ArrayUtils.orElse((List)event.getRangeTombstoneList(), (List)ImmutableList.of()).stream().map(messageConverter::toCdcMessage).collect(Collectors.toList()), CdcMessage.complexCellDeletion(event.getTombstonedCellsInComplex(), CdcMessage.typeProvider(messageConverter.types, event)), event.getTtl());
    }

    private static Function<String, CqlField.CqlType> typeProvider(CassandraTypes types, CdcEvent event) {
        List cols = ArrayUtils.combine((List[])new List[]{event.getPartitionKeys(), event.getClusteringKeys(), event.getStaticColumns(), event.getValueColumns()});
        Map<String, CqlField.CqlType> typeMap = cols.stream().collect(Collectors.toMap(value -> value.columnName, value -> types.parseType(event.keyspace, value.columnType)));
        return typeMap::get;
    }

    public CdcMessage(String keyspace, String table, List<Column> partitionKeys, List<Column> clusteringKeys, List<Column> staticColumns, List<Column> valueColumns, long maxTimestampMicros, CdcEvent.Kind operationType, List<RangeTombstoneMsg> rangeTombstoneList, @Nullable Map<String, List<Object>> complexCellDeletion, @Nullable CdcEvent.TimeToLive ttl) {
        this.keyspace = keyspace;
        this.table = table;
        this.partitionKeys = partitionKeys;
        this.clusteringKeys = clusteringKeys;
        this.staticColumns = staticColumns;
        this.valueColumns = valueColumns;
        this.maxTimestampMicros = maxTimestampMicros;
        this.operationType = operationType;
        this.rangeTombstoneList = rangeTombstoneList;
        this.columns = new HashMap<String, Column>(partitionKeys.size() + clusteringKeys.size() + staticColumns.size() + valueColumns.size());
        partitionKeys.forEach(col -> this.columns.put(col.name(), (Column)col));
        clusteringKeys.forEach(col -> this.columns.put(col.name(), (Column)col));
        staticColumns.forEach(col -> this.columns.put(col.name(), (Column)col));
        valueColumns.forEach(col -> this.columns.put(col.name(), (Column)col));
        this.complexCellDeletion = complexCellDeletion;
        this.ttl = ttl;
    }

    private static Map<String, List<Object>> complexCellDeletion(@Nullable Map<String, List<ByteBuffer>> tombstonedCellsInComplex, Function<String, CqlField.CqlType> typeProvider) {
        if (tombstonedCellsInComplex == null) {
            return null;
        }
        return tombstonedCellsInComplex.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            CqlField.CqlCollection type = (CqlField.CqlCollection)typeProvider.apply((String)entry.getKey());
            return ((List)entry.getValue()).stream().map(ByteBuffer::duplicate).map(buf -> type.type().deserializeToJavaType(buf)).collect(Collectors.toList());
        }));
    }

    private static List<Column> toColumns(JdkMessageConverter messageConverter, List<Value> values) {
        if (values == null) {
            return ImmutableList.of();
        }
        return values.stream().map(messageConverter::toCdcMessage).collect(Collectors.toList());
    }

    public String keyspace() {
        return this.keyspace;
    }

    public String table() {
        return this.table;
    }

    public List<Column> partitionKeys() {
        return this.partitionKeys;
    }

    public List<Column> clusteringKeys() {
        return this.clusteringKeys;
    }

    public List<Column> staticColumns() {
        return this.staticColumns;
    }

    public List<Column> valueColumns() {
        return this.valueColumns;
    }

    @Nullable
    public CdcEvent.TimeToLive ttl() {
        return this.ttl;
    }

    @Nullable
    public Map<String, List<Object>> getComplexCellDeletion() {
        return this.complexCellDeletion;
    }

    public List<RangeTombstoneMsg> rangeTombstones() {
        return this.rangeTombstoneList;
    }

    public long lastModifiedTimeMicros() {
        return this.maxTimestampMicros;
    }

    public CdcEvent.Kind operationType() {
        return this.operationType;
    }

    public List<Column> primaryKeys() {
        return ArrayUtils.combine((List[])new List[]{this.partitionKeys, this.clusteringKeys});
    }

    public List<Column> allColumns() {
        return ArrayUtils.combine((List[])new List[]{this.partitionKeys, this.clusteringKeys, this.staticColumns, this.valueColumns});
    }

    @Nullable
    public Column column(String name) {
        return this.columns.get(name);
    }

    public Instant lastModifiedTime() {
        return Instant.EPOCH.plus(this.maxTimestampMicros, ChronoUnit.MICROS);
    }

    public String toString() {
        return "{\"operation\": " + String.valueOf(this.operationType) + ", \"lastModifiedTimestamp\": " + this.maxTimestampMicros + ", " + ArrayUtils.concatToStream((List[])new List[]{this.partitionKeys, this.clusteringKeys, this.staticColumns, this.valueColumns}).map(Object::toString).collect(Collectors.joining(", ")) + "}";
    }
}

