/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.CassandraBulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CassandraCoordinatedBulkWriterContext;
import org.apache.cassandra.spark.utils.ScalaFunctions;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ShutdownHookManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkWriterContextFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkWriterContextFactory.class);

    @NotNull
    public BulkWriterContext createBulkWriterContext(@NotNull SparkContext sparkContext, @NotNull Map<String, String> options, @NotNull StructType schema) {
        BulkWriterContext bulkWriterContext;
        Preconditions.checkNotNull((Object)schema);
        BulkSparkConf conf = this.createBulkSparkConf(sparkContext, options);
        int sparkDefaultParallelism = sparkContext.defaultParallelism();
        if (conf.isCoordinatedWriteConfigured()) {
            LOGGER.info("Initializing bulk writer context for multi-clusters coordinated write");
            bulkWriterContext = this.createCoordinatedBulkWriterContext(conf, schema, sparkDefaultParallelism);
        } else {
            LOGGER.info("Initializing bulk writer context for single cluster write");
            bulkWriterContext = this.createBulkWriterContext(conf, schema, sparkDefaultParallelism);
        }
        ShutdownHookManager.addShutdownHook((int)ShutdownHookManager.TEMP_DIR_SHUTDOWN_PRIORITY(), ScalaFunctions.wrapLambda(bulkWriterContext::shutdown));
        this.publishInitialJobStats(bulkWriterContext, sparkContext.version());
        return bulkWriterContext;
    }

    @NotNull
    protected BulkSparkConf createBulkSparkConf(@NotNull SparkContext sparkContext, @NotNull Map<String, String> options) {
        return new BulkSparkConf(sparkContext.getConf(), options, LOGGER);
    }

    @NotNull
    protected BulkWriterContext createBulkWriterContext(@NotNull BulkSparkConf conf, StructType schema, int sparkDefaultParallelism) {
        return new CassandraBulkWriterContext(conf, schema, sparkDefaultParallelism);
    }

    @NotNull
    protected BulkWriterContext createCoordinatedBulkWriterContext(@NotNull BulkSparkConf conf, StructType schema, int sparkDefaultParallelism) {
        return new CassandraCoordinatedBulkWriterContext(conf, schema, sparkDefaultParallelism);
    }

    protected void publishInitialJobStats(BulkWriterContext context, final String sparkVersion) {
        final JobInfo jobInfo = context.job();
        HashMap<String, String> initialJobStats = new HashMap<String, String>(){
            {
                this.put("jobId", jobInfo.getId());
                this.put("sparkVersion", sparkVersion);
                this.put("keyspace", jobInfo.qualifiedTableName().keyspace());
                this.put("table", jobInfo.qualifiedTableName().table());
            }
        };
        context.jobStats().publish((Map)initialJobStats);
    }
}

