/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.netty.resolver.dns;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import o.a.c.sidecar.client.shaded.io.netty.channel.ChannelFactory;
import o.a.c.sidecar.client.shaded.io.netty.channel.EventLoop;
import o.a.c.sidecar.client.shaded.io.netty.channel.socket.DatagramChannel;
import o.a.c.sidecar.client.shaded.io.netty.resolver.AddressResolver;
import o.a.c.sidecar.client.shaded.io.netty.resolver.AddressResolverGroup;
import o.a.c.sidecar.client.shaded.io.netty.resolver.InetSocketAddressResolver;
import o.a.c.sidecar.client.shaded.io.netty.resolver.NameResolver;
import o.a.c.sidecar.client.shaded.io.netty.resolver.dns.DnsNameResolverBuilder;
import o.a.c.sidecar.client.shaded.io.netty.resolver.dns.DnsServerAddressStreamProvider;
import o.a.c.sidecar.client.shaded.io.netty.resolver.dns.InflightNameResolver;
import o.a.c.sidecar.client.shaded.io.netty.util.concurrent.EventExecutor;
import o.a.c.sidecar.client.shaded.io.netty.util.concurrent.Promise;
import o.a.c.sidecar.client.shaded.io.netty.util.internal.PlatformDependent;
import o.a.c.sidecar.client.shaded.io.netty.util.internal.StringUtil;

public class DnsAddressResolverGroup
extends AddressResolverGroup<InetSocketAddress> {
    private final DnsNameResolverBuilder dnsResolverBuilder;
    private final ConcurrentMap<String, Promise<InetAddress>> resolvesInProgress = PlatformDependent.newConcurrentHashMap();
    private final ConcurrentMap<String, Promise<List<InetAddress>>> resolveAllsInProgress = PlatformDependent.newConcurrentHashMap();

    public DnsAddressResolverGroup(DnsNameResolverBuilder dnsResolverBuilder) {
        this.dnsResolverBuilder = dnsResolverBuilder.copy();
    }

    public DnsAddressResolverGroup(Class<? extends DatagramChannel> channelType, DnsServerAddressStreamProvider nameServerProvider) {
        this.dnsResolverBuilder = new DnsNameResolverBuilder();
        this.dnsResolverBuilder.channelType(channelType).nameServerProvider(nameServerProvider);
    }

    public DnsAddressResolverGroup(ChannelFactory<? extends DatagramChannel> channelFactory, DnsServerAddressStreamProvider nameServerProvider) {
        this.dnsResolverBuilder = new DnsNameResolverBuilder();
        this.dnsResolverBuilder.channelFactory(channelFactory).nameServerProvider(nameServerProvider);
    }

    @Override
    protected final AddressResolver<InetSocketAddress> newResolver(EventExecutor executor) throws Exception {
        if (!(executor instanceof EventLoop)) {
            throw new IllegalStateException("unsupported executor type: " + StringUtil.simpleClassName(executor) + " (expected: " + StringUtil.simpleClassName(EventLoop.class));
        }
        EventLoop loop = this.dnsResolverBuilder.eventLoop;
        return this.newResolver(loop == null ? (EventLoop)executor : loop, this.dnsResolverBuilder.channelFactory(), this.dnsResolverBuilder.nameServerProvider());
    }

    @Deprecated
    protected AddressResolver<InetSocketAddress> newResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, DnsServerAddressStreamProvider nameServerProvider) throws Exception {
        InflightNameResolver<InetAddress> resolver = new InflightNameResolver<InetAddress>(eventLoop, this.newNameResolver(eventLoop, channelFactory, nameServerProvider), this.resolvesInProgress, this.resolveAllsInProgress);
        return this.newAddressResolver(eventLoop, resolver);
    }

    protected NameResolver<InetAddress> newNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, DnsServerAddressStreamProvider nameServerProvider) throws Exception {
        DnsNameResolverBuilder builder = this.dnsResolverBuilder.copy();
        return builder.eventLoop(eventLoop).channelFactory(channelFactory).nameServerProvider(nameServerProvider).build();
    }

    protected AddressResolver<InetSocketAddress> newAddressResolver(EventLoop eventLoop, NameResolver<InetAddress> resolver) throws Exception {
        return new InetSocketAddressResolver((EventExecutor)eventLoop, resolver);
    }
}

