/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.common.response;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import o.a.c.sidecar.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import o.a.c.sidecar.client.shaded.common.DataObjectBuilder;

public class NodeSettings {
    private static final String VERSION = "version";
    @JsonProperty(value="releaseVersion")
    private final String releaseVersion;
    @JsonProperty(value="partitioner")
    private final String partitioner;
    @JsonProperty(value="datacenter")
    private final String datacenter;
    @JsonProperty(value="rpcAddress")
    private final InetAddress rpcAddress;
    @JsonProperty(value="rpcPort")
    private final int rpcPort;
    @JsonProperty(value="tokens")
    private final Set<String> tokens;
    @JsonProperty(value="sidecar")
    private final Map<String, String> sidecar;

    public NodeSettings() {
        this(NodeSettings.builder());
    }

    protected NodeSettings(Builder builder) {
        this.releaseVersion = builder.releaseVersion;
        this.partitioner = builder.partitioner;
        this.datacenter = builder.datacenter;
        this.rpcAddress = builder.rpcAddress;
        this.rpcPort = builder.rpcPort;
        this.tokens = builder.tokens;
        this.sidecar = builder.sidecar;
    }

    @JsonProperty(value="releaseVersion")
    public String releaseVersion() {
        return this.releaseVersion;
    }

    @JsonProperty(value="partitioner")
    public String partitioner() {
        return this.partitioner;
    }

    @JsonProperty(value="sidecar")
    public Map<String, String> sidecar() {
        return this.sidecar;
    }

    public String sidecarVersion() {
        return this.sidecar != null ? this.sidecar.get(VERSION) : "unknown";
    }

    @JsonProperty(value="datacenter")
    public String datacenter() {
        return this.datacenter;
    }

    @JsonProperty(value="rpcAddress")
    public InetAddress rpcAddress() {
        return this.rpcAddress;
    }

    @JsonProperty(value="rpcPort")
    public int rpcPort() {
        return this.rpcPort;
    }

    @JsonProperty(value="tokens")
    public Set<String> tokens() {
        return this.tokens;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        NodeSettings that = (NodeSettings)other;
        return Objects.equals(this.releaseVersion, that.releaseVersion) && Objects.equals(this.partitioner, that.partitioner) && Objects.equals(this.sidecar, that.sidecar) && Objects.equals(this.datacenter, that.datacenter) && Objects.equals(this.rpcAddress, that.rpcAddress) && Objects.equals(this.rpcPort, that.rpcPort) && Objects.equals(this.tokens, that.tokens);
    }

    public int hashCode() {
        return Objects.hash(this.releaseVersion, this.partitioner, this.sidecar, this.datacenter, this.rpcAddress, this.rpcPort, this.tokens);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements DataObjectBuilder<Builder, NodeSettings> {
        private String releaseVersion;
        private String partitioner;
        private String datacenter;
        private InetAddress rpcAddress;
        private int rpcPort;
        private Set<String> tokens;
        private Map<String, String> sidecar;

        private Builder() {
        }

        @Override
        public Builder self() {
            return this;
        }

        public Builder releaseVersion(String releaseVersion) {
            return this.update(b -> {
                b.releaseVersion = releaseVersion;
            });
        }

        public Builder partitioner(String partitioner) {
            return this.update(b -> {
                b.partitioner = partitioner;
            });
        }

        public Builder datacenter(String datacenter) {
            return this.update(b -> {
                b.datacenter = datacenter;
            });
        }

        public Builder rpcAddress(InetAddress rpcAddress) {
            return this.update(b -> {
                b.rpcAddress = rpcAddress;
            });
        }

        public Builder rpcPort(int rpcPort) {
            return this.update(b -> {
                b.rpcPort = rpcPort;
            });
        }

        public Builder tokens(Set<String> tokens) {
            return this.update(b -> {
                b.tokens = tokens;
            });
        }

        public Builder sidecar(Map<String, String> sidecar) {
            return this.update(b -> {
                b.sidecar = sidecar;
            });
        }

        public Builder sidecarVersion(String sidecarVersion) {
            return this.update(b -> {
                if (b.sidecar != null) {
                    b.sidecar.put(NodeSettings.VERSION, sidecarVersion);
                } else {
                    b.sidecar = Collections.singletonMap(NodeSettings.VERSION, sidecarVersion);
                }
            });
        }

        @Override
        public NodeSettings build() {
            return new NodeSettings(this);
        }
    }
}

