/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.kafka;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.cassandra.cdc.msg.CdcEvent;
import org.apache.cassandra.cdc.msg.Value;
import org.apache.kafka.common.utils.Utils;

public interface EventHasher {
    public static final EventHasher MURMUR2 = event -> {
        ByteBuffer[] values = (ByteBuffer[])event.getPartitionKeys().stream().map(Value::getValue).toArray(ByteBuffer[]::new);
        byte[] ar = new byte[Arrays.stream(values).mapToInt(Buffer::remaining).sum()];
        int pos = 0;
        for (ByteBuffer buf : values) {
            int len = buf.remaining();
            buf.get(ar, pos, len);
            pos += len;
        }
        return Integer.toHexString(Utils.murmur2((byte[])ar));
    };

    public String hashEvent(CdcEvent var1);
}

