/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import com.google.common.net.InetAddresses;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.IntStream;
import org.apache.cassandra.spark.data.partitioner.Partitioner;

public final class RandomUtils {
    public static final int MIN_COLLECTION_SIZE = 16;
    public static final Random RANDOM = new Random();

    private RandomUtils() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static byte randomByte() {
        return RandomUtils.randomBytes(1)[0];
    }

    public static byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        RANDOM.nextBytes(bytes);
        return bytes;
    }

    public static ByteBuffer randomByteBuffer(int length) {
        return ByteBuffer.wrap(RandomUtils.randomBytes(length));
    }

    public static int randomPositiveInt(int bound) {
        return RANDOM.nextInt(bound - 1) + 1;
    }

    public static int nextInt(int startInclusive, int endExclusive) {
        if (endExclusive <= startInclusive) {
            throw new IllegalArgumentException("Start value must be less than the end value.");
        }
        if (startInclusive < 0) {
            throw new IllegalArgumentException("Both range values must be non-negative.");
        }
        return startInclusive + RANDOM.nextInt(endExclusive - startInclusive);
    }

    public static BigInteger randomBigInteger(Partitioner partitioner) {
        BigInteger range = partitioner.maxToken().subtract(partitioner.minToken());
        int length = partitioner.maxToken().bitLength();
        BigInteger result = new BigInteger(length, RANDOM);
        if (result.compareTo(partitioner.minToken()) < 0) {
            result = result.add(partitioner.minToken());
        }
        if (result.compareTo(range) >= 0) {
            result = result.mod(range).add(partitioner.minToken());
        }
        return result;
    }

    public static UUID getRandomTimeUUIDForTesting() {
        UUID uuid = UUID.randomUUID();
        return new UUID(uuid.getMostSignificantBits() ^ 0x5000L, uuid.getLeastSignificantBits() | 0x10000000000L);
    }

    public static InetAddress randomInet() {
        return InetAddresses.fromInteger((int)RANDOM.nextInt());
    }

    public static String randomAlphanumeric(int minLengthInclusive, int maxLengthExclusive) {
        return RandomUtils.randomAlphanumeric(RandomUtils.nextInt(minLengthInclusive, maxLengthExclusive));
    }

    public static String randomAlphanumeric(Set<String> alreadyExist) {
        return RandomUtils.randomAlphanumeric(alreadyExist, 32);
    }

    public static String randomAlphanumeric(Set<String> alreadyExist, int length) {
        String str = RandomUtils.randomAlphanumeric(length);
        while (alreadyExist.contains(str)) {
            str = RandomUtils.randomAlphanumeric(length);
        }
        return str;
    }

    public static String randomAlphanumeric() {
        return RandomUtils.randomAlphanumeric(32);
    }

    public static String randomAlphanumeric(int length) {
        StringBuilder sb = new StringBuilder(length);
        IntStream.range(0, length).mapToObj(i -> Character.valueOf(RandomUtils.randomAsciiAlphanumeric())).forEach(sb::append);
        return sb.toString();
    }

    public static char randomAsciiAlphanumeric() {
        int c = RANDOM.nextInt(36);
        if (c < 10) {
            return (char)(c + 48);
        }
        return (char)(c - 10 + 65);
    }
}

