/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.cassandra.spark.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapUtils.class);

    private MapUtils() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static <K, V> Map<K, V> mapOf(Object ... keys) {
        Preconditions.checkArgument(keys.length % 2 == 0, "Must be matching number of key-value pairs", new Object[0]);
        HashMap<Object, Object> result = new HashMap<Object, Object>(keys.length / 2);
        for (int i = 0; i < keys.length; i += 2) {
            result.put(keys[i], keys[i + 1]);
        }
        return result;
    }

    public static String lowerCaseKey(String key) {
        return key != null ? key.toLowerCase(Locale.ROOT) : null;
    }

    public static String getOrThrow(Map<String, String> options, String key) {
        return MapUtils.getOrThrow(options, key, key);
    }

    public static String getOrThrow(Map<String, String> options, String key, String name) {
        return MapUtils.getOrThrow(options, key, MapUtils.throwable(name));
    }

    public static Supplier<RuntimeException> throwable(String name) {
        return () -> new RuntimeException(String.format("No %s specified", name));
    }

    public static String getOrThrow(Map<String, String> options, String key, Supplier<RuntimeException> throwable) {
        return MapUtils.getOrHandle(options, key, () -> {
            throw (RuntimeException)throwable.get();
        });
    }

    public static String getOrHandle(Map<String, String> options, String key, Supplier<String> handler) {
        String value = options.get(MapUtils.lowerCaseKey(key));
        if (value == null) {
            return handler.get();
        }
        return value;
    }

    public static boolean getBoolean(Map<String, String> options, String key, boolean defaultValue) {
        return MapUtils.getBoolean(options, key, defaultValue, null);
    }

    public static boolean getBoolean(Map<String, String> options, String key, boolean defaultValue, String displayName) {
        String value = options.get(MapUtils.lowerCaseKey(key));
        if (value == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        displayName = displayName != null ? displayName : key;
        throw new IllegalArgumentException("Key " + displayName + " with value " + value + " is not a valid boolean string");
    }

    public static int getInt(Map<String, String> options, String key, int defaultValue) {
        return MapUtils.getInt(options, key, defaultValue, null);
    }

    public static int getInt(Map<String, String> options, String key, int defaultValue, String displayName) {
        return MapUtils.getOptionalInt(options, key, displayName).orElse(defaultValue);
    }

    public static Optional<Integer> getOptionalInt(Map<String, String> options, String key, String displayName) {
        String value = options.get(MapUtils.lowerCaseKey(key));
        try {
            return value != null ? Optional.of(Integer.parseInt(value)) : Optional.empty();
        }
        catch (NumberFormatException exception) {
            displayName = displayName != null ? displayName : key;
            throw new IllegalArgumentException("Key " + displayName + " with value " + value + " is not a valid integer string.", exception);
        }
    }

    public static long getLong(Map<String, String> options, String key, long defaultValue) {
        String value = options.get(MapUtils.lowerCaseKey(key));
        return value != null ? Long.parseLong(value) : defaultValue;
    }

    public static <T extends Enum<T>> T getEnumOption(Map<String, String> options, String key, T defaultValue, String displayName) {
        String value = options.get(MapUtils.lowerCaseKey(key));
        try {
            return value != null ? Enum.valueOf(defaultValue.getDeclaringClass(), value) : defaultValue;
        }
        catch (IllegalArgumentException exception) {
            displayName = displayName != null ? displayName : key;
            throw new IllegalArgumentException("Key " + displayName + " with value " + value + " is not a valid Enum of type " + String.valueOf(defaultValue.getClass()) + ".", exception);
        }
    }

    public static String getOrDefault(Map<String, String> options, String key, String defaultValue) {
        return options.getOrDefault(MapUtils.lowerCaseKey(key), defaultValue);
    }

    public static boolean containsKey(Map<String, String> options, String key) {
        return options.containsKey(MapUtils.lowerCaseKey(key));
    }

    public static <T> T resolveDeprecated(Map<String, String> options, String option, String deprecated, Function<String, T> resolver) {
        T deprecatedOptionValue = null;
        if (options.containsKey(deprecated)) {
            LOGGER.warn("The option: {} is deprecated. Please use {} instead. See option description for details.", (Object)deprecated, (Object)option);
            deprecatedOptionValue = resolver.apply(deprecated);
        }
        if (options.containsKey(option)) {
            if (deprecatedOptionValue != null) {
                LOGGER.info("The option: {} is defined. Favor the value over {}", (Object)option, (Object)deprecated);
            }
            return resolver.apply(option);
        }
        return deprecatedOptionValue == null ? (T)resolver.apply(null) : deprecatedOptionValue;
    }
}

