/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CassandraVersionFeatures
implements Comparable<CassandraVersionFeatures> {
    private static final Pattern VERSION_PATTERN_3 = Pattern.compile("(?:.+-)?([0-9]+)\\.([0-9]+)\\.([0-9]+)([a-zA-Z0-9-]*)");
    private static final Pattern VERSION_PATTERN_4 = Pattern.compile("(?:.+-)?([0-9]+)\\.([0-9]+)\\.([0-9]+)\\.([0-9]+)[a-zA-Z0-9-]*");
    private static final Pattern VERSION_PATTERN_SNAPSHOT = Pattern.compile("(?:.+-)?([0-9]+)\\.([0-9]+)-(SNAPSHOT)$");
    protected final int majorVersion;
    protected final int minorVersion;
    protected final String suffix;
    private final String rawVersionString;

    @VisibleForTesting
    public CassandraVersionFeatures(int majorVersion, int minorVersion, @Nullable String suffix) {
        this(majorVersion, minorVersion, suffix, null);
    }

    public CassandraVersionFeatures(int majorVersion, int minorVersion, @Nullable String suffix, @Nullable String rawVersionString) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.suffix = suffix;
        this.rawVersionString = rawVersionString;
    }

    public static CassandraVersionFeatures cassandraVersionFeaturesFromCassandraVersion(@NotNull String cassandraVersion) {
        String versionCode = CassandraVersionFeatures.getCassandraVersionCode(cassandraVersion);
        String minorVersionCode = CassandraVersionFeatures.getCassandraMinorVersionCode(cassandraVersion);
        String versionSuffix = CassandraVersionFeatures.getCassandraVersionSuffix(cassandraVersion);
        return new CassandraVersionFeatures(Integer.parseInt(versionCode), Integer.parseInt(minorVersionCode), versionSuffix, cassandraVersion);
    }

    private static String getCassandraVersionCode(String cassandraVersion) {
        Matcher matcher = CassandraVersionFeatures.matchVersion(cassandraVersion);
        return matcher.group(1) + matcher.group(2);
    }

    private static String getCassandraMinorVersionCode(String cassandraVersion) {
        Matcher matcher = CassandraVersionFeatures.matchVersion(cassandraVersion);
        if (CassandraVersionFeatures.matchesSnapshot(matcher.group(3))) {
            return "0";
        }
        return matcher.group(3);
    }

    private static String getCassandraVersionSuffix(String cassandraVersion) {
        Matcher matcher = CassandraVersionFeatures.matchVersion(cassandraVersion);
        if (CassandraVersionFeatures.matchesSnapshot(matcher.group(3)) || CassandraVersionFeatures.matchesSnapshot(matcher.group(4))) {
            return "SNAPSHOT";
        }
        return matcher.group(4);
    }

    private static boolean matchesSnapshot(String snapshot) {
        return "SNAPSHOT".equals(snapshot) || "-SNAPSHOT".equals(snapshot);
    }

    private static Matcher matchVersion(String cassandraVersion) {
        Matcher matcher = VERSION_PATTERN_4.matcher(cassandraVersion);
        if (!(matcher.find() || (matcher = VERSION_PATTERN_3.matcher(cassandraVersion)).find() || (matcher = VERSION_PATTERN_SNAPSHOT.matcher(cassandraVersion)).find())) {
            throw new RuntimeException("cassandraVersion does not match version pattern, pattern=" + String.valueOf(VERSION_PATTERN_3) + ", version=" + cassandraVersion);
        }
        return matcher;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getRawVersionString() {
        return this.rawVersionString;
    }

    @Override
    public int compareTo(@NotNull CassandraVersionFeatures that) {
        int difference = this.getMajorVersion() - that.getMajorVersion();
        if (difference != 0) {
            return difference;
        }
        difference = this.getMinorVersion() - that.getMinorVersion();
        if (difference != 0) {
            return difference;
        }
        try {
            return Integer.parseInt(this.getSuffix()) - Integer.parseInt(that.getSuffix());
        }
        catch (NumberFormatException exception) {
            int thisLength = this.getSuffix() != null ? this.getSuffix().length() : 0;
            int thatLength = that.getSuffix() != null ? that.getSuffix().length() : 0;
            return thisLength - thatLength;
        }
    }

    public boolean equals(@Nullable Object other) {
        if (other == null || !(other instanceof CassandraVersionFeatures)) {
            return false;
        }
        CassandraVersionFeatures that = (CassandraVersionFeatures)other;
        return Objects.equals(this.majorVersion, that.majorVersion) && Objects.equals(this.minorVersion, that.minorVersion) && Objects.equals(this.suffix, that.suffix);
    }

    public int hashCode() {
        return Objects.hash(this.majorVersion, this.minorVersion, this.suffix);
    }

    @NotNull
    public String toString() {
        return String.format("CassandraVersionFeatures{majorVersion=%d, minorVersion=%d, suffix='%s'}", this.majorVersion, this.minorVersion, this.suffix);
    }
}

