/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.segment;

import java.io.Closeable;
import java.io.IOException;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.disk.PrimaryKeyMap;
import org.apache.cassandra.index.sai.disk.v1.PerColumnIndexFiles;
import org.apache.cassandra.index.sai.disk.v1.postings.PostingListRangeIterator;
import org.apache.cassandra.index.sai.disk.v1.segment.IndexSegmentSearcherContext;
import org.apache.cassandra.index.sai.disk.v1.segment.LiteralIndexSegmentSearcher;
import org.apache.cassandra.index.sai.disk.v1.segment.NumericIndexSegmentSearcher;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentMetadata;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentOrdering;
import org.apache.cassandra.index.sai.disk.v1.segment.VectorIndexSegmentSearcher;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.postings.PeekablePostingList;
import org.apache.cassandra.index.sai.postings.PostingList;

public abstract class IndexSegmentSearcher
implements SegmentOrdering,
Closeable {
    final PrimaryKeyMap.Factory primaryKeyMapFactory;
    final PerColumnIndexFiles indexFiles;
    final SegmentMetadata metadata;
    final StorageAttachedIndex index;

    IndexSegmentSearcher(PrimaryKeyMap.Factory primaryKeyMapFactory, PerColumnIndexFiles perIndexFiles, SegmentMetadata segmentMetadata, StorageAttachedIndex index) {
        this.primaryKeyMapFactory = primaryKeyMapFactory;
        this.indexFiles = perIndexFiles;
        this.metadata = segmentMetadata;
        this.index = index;
    }

    public static IndexSegmentSearcher open(PrimaryKeyMap.Factory primaryKeyMapFactory, PerColumnIndexFiles indexFiles, SegmentMetadata segmentMetadata, StorageAttachedIndex index) throws IOException {
        if (index.termType().isVector()) {
            return new VectorIndexSegmentSearcher(primaryKeyMapFactory, indexFiles, segmentMetadata, index);
        }
        if (index.termType().isLiteral()) {
            return new LiteralIndexSegmentSearcher(primaryKeyMapFactory, indexFiles, segmentMetadata, index);
        }
        return new NumericIndexSegmentSearcher(primaryKeyMapFactory, indexFiles, segmentMetadata, index);
    }

    public abstract long indexFileCacheSize();

    public abstract KeyRangeIterator search(Expression var1, AbstractBounds<PartitionPosition> var2, QueryContext var3) throws IOException;

    KeyRangeIterator toPrimaryKeyIterator(PostingList postingList, QueryContext queryContext) throws IOException {
        if (postingList == null || postingList.size() == 0L) {
            return KeyRangeIterator.empty();
        }
        IndexSegmentSearcherContext searcherContext = new IndexSegmentSearcherContext(this.metadata.minKey, this.metadata.maxKey, this.metadata.rowIdOffset, queryContext, PeekablePostingList.makePeekable(postingList));
        return new PostingListRangeIterator(this.index.identifier(), this.primaryKeyMapFactory.newPerSSTablePrimaryKeyMap(), searcherContext);
    }
}

