/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.io.IOException;
import org.apache.cassandra.cache.CacheProvider;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.cache.RowCacheSentinel;
import org.apache.cassandra.cache.SerializingCache;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public class SerializingCacheProvider
implements CacheProvider<RowCacheKey, IRowCacheEntry> {
    @Override
    public ICache<RowCacheKey, IRowCacheEntry> create() {
        return SerializingCache.create(DatabaseDescriptor.getRowCacheSizeInMiB() * 1024L * 1024L, new RowCacheSerializer());
    }

    public static class RowCacheSerializer
    implements ISerializer<IRowCacheEntry> {
        @Override
        public void serialize(IRowCacheEntry entry, DataOutputPlus out) throws IOException {
            assert (entry != null);
            boolean isSentinel = entry instanceof RowCacheSentinel;
            out.writeBoolean(isSentinel);
            if (isSentinel) {
                out.writeLong(((RowCacheSentinel)entry).sentinelId);
            } else {
                CachedPartition.cacheSerializer.serialize((CachedPartition)entry, out);
            }
        }

        @Override
        public IRowCacheEntry deserialize(DataInputPlus in) throws IOException {
            boolean isSentinel = in.readBoolean();
            if (isSentinel) {
                return new RowCacheSentinel(in.readLong());
            }
            return CachedPartition.cacheSerializer.deserialize(in);
        }

        @Override
        public long serializedSize(IRowCacheEntry entry) {
            int size = TypeSizes.sizeof(true);
            size = entry instanceof RowCacheSentinel ? (size += TypeSizes.sizeof(((RowCacheSentinel)entry).sentinelId)) : (int)((long)size + CachedPartition.cacheSerializer.serializedSize((CachedPartition)entry));
            return size;
        }
    }
}

