/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.awss3cdcsource;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelAwss3cdcsourceSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_QUEUE_NAME_OR_ARN_CONF = "camel.kamelet.aws-s3-cdc-source.queueNameOrArn";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_QUEUE_NAME_OR_ARN_DOC = "The SQS Queue Name or ARN";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_QUEUE_NAME_OR_ARN_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_DELETE_AFTER_READ_CONF = "camel.kamelet.aws-s3-cdc-source.deleteAfterRead";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_DELETE_AFTER_READ_DOC = "Delete messages after consuming them";
    public static final Boolean CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_DELETE_AFTER_READ_DEFAULT = true;
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_ACCESS_KEY_CONF = "camel.kamelet.aws-s3-cdc-source.accessKey";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_ACCESS_KEY_DOC = "The access key obtained from AWS.";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_ACCESS_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_SECRET_KEY_CONF = "camel.kamelet.aws-s3-cdc-source.secretKey";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_SECRET_KEY_DOC = "The secret key obtained from AWS.";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_SECRET_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_REGION_CONF = "camel.kamelet.aws-s3-cdc-source.region";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_REGION_DOC = "The AWS region to access.";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_REGION_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_AUTO_CREATE_QUEUE_CONF = "camel.kamelet.aws-s3-cdc-source.autoCreateQueue";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_AUTO_CREATE_QUEUE_DOC = "Setting the autocreation of the SQS queue.";
    public static final Boolean CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_AUTO_CREATE_QUEUE_DEFAULT = false;
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_AMAZON_AWSHOST_CONF = "camel.kamelet.aws-s3-cdc-source.amazonAWSHost";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_AMAZON_AWSHOST_DOC = "The hostname of the Amazon AWS cloud.";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_AMAZON_AWSHOST_DEFAULT = "amazonaws.com";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_PROTOCOL_CONF = "camel.kamelet.aws-s3-cdc-source.protocol";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_PROTOCOL_DOC = "The underlying protocol used to communicate with SQS Example: http or https";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_PROTOCOL_DEFAULT = "https";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_QUEUE_URLCONF = "camel.kamelet.aws-s3-cdc-source.queueURL";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_QUEUE_URLDOC = "The full SQS Queue URL (required if using KEDA)";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_QUEUE_URLDEFAULT = null;
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_URI_ENDPOINT_OVERRIDE_CONF = "camel.kamelet.aws-s3-cdc-source.uriEndpointOverride";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_URI_ENDPOINT_OVERRIDE_DOC = "The overriding endpoint URI. To use this option, you must also select the `overrideEndpoint` option.";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_URI_ENDPOINT_OVERRIDE_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_OVERRIDE_ENDPOINT_CONF = "camel.kamelet.aws-s3-cdc-source.overrideEndpoint";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_OVERRIDE_ENDPOINT_DOC = "Select this option to override the endpoint URI. To use this option, you must also provide a URI for the `uriEndpointOverride` option.";
    public static final Boolean CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_OVERRIDE_ENDPOINT_DEFAULT = false;
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_DELAY_CONF = "camel.kamelet.aws-s3-cdc-source.delay";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_DELAY_DOC = "The number of milliseconds before the next poll of the selected stream";
    public static final Integer CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_DELAY_DEFAULT = 500;
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_GREEDY_CONF = "camel.kamelet.aws-s3-cdc-source.greedy";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_GREEDY_DOC = "If greedy is enabled, then the polling will happen immediately again, if the previous run polled 1 or more messages.";
    public static final Boolean CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_GREEDY_DEFAULT = false;
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_GET_OBJECT_CONF = "camel.kamelet.aws-s3-cdc-source.getObject";
    public static final String CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_GET_OBJECT_DOC = "If getObject is enabled, then the file created in the bucket will be get and returned as body, if not only the event will returned as body.";
    public static final Boolean CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_GET_OBJECT_DEFAULT = false;

    public CamelAwss3cdcsourceSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelAwss3cdcsourceSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_QUEUE_NAME_OR_ARN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_QUEUE_NAME_OR_ARN_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_QUEUE_NAME_OR_ARN_DOC);
        conf.define(CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_DELETE_AFTER_READ_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_DELETE_AFTER_READ_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_DELETE_AFTER_READ_DOC);
        conf.define(CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_ACCESS_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_ACCESS_KEY_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_ACCESS_KEY_DOC);
        conf.define(CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_SECRET_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_SECRET_KEY_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_SECRET_KEY_DOC);
        conf.define(CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_REGION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_REGION_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_REGION_DOC);
        conf.define(CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_AUTO_CREATE_QUEUE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_AUTO_CREATE_QUEUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_AUTO_CREATE_QUEUE_DOC);
        conf.define(CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_AMAZON_AWSHOST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_AMAZON_AWSHOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_AMAZON_AWSHOST_DOC);
        conf.define(CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_PROTOCOL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_PROTOCOL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_PROTOCOL_DOC);
        conf.define(CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_QUEUE_URLCONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_QUEUE_URLDEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_QUEUE_URLDOC);
        conf.define(CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_URI_ENDPOINT_OVERRIDE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_URI_ENDPOINT_OVERRIDE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_URI_ENDPOINT_OVERRIDE_DOC);
        conf.define(CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_OVERRIDE_ENDPOINT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_OVERRIDE_ENDPOINT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_OVERRIDE_ENDPOINT_DOC);
        conf.define(CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_DELAY_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_DELAY_DOC);
        conf.define(CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_GREEDY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_GREEDY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_GREEDY_DOC);
        conf.define(CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_GET_OBJECT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_GET_OBJECT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSS3CDCSOURCE_KAMELET_GET_OBJECT_DOC);
        return conf;
    }
}