/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location;

import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import java.io.File;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.BrooklynFeatureEnablement;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.crypto.SecureKeys;
import org.apache.brooklyn.util.crypto.AuthorizedKeysParser;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(LocationConfigUtils.class);
    public static String BROOKLYN_LOCATION_PREFIX = "brooklyn.location";

    public static OsCredential getOsCredential(ConfigBag config) {
        return OsCredential.newInstance(config);
    }

    private static String getKeyDataFromDataKeyOrFileKey(ConfigBag config, ConfigKey<String> dataKey, ConfigKey<String> fileKey) {
        boolean unused = config.isUnused(dataKey);
        String data = config.get(dataKey);
        if (Strings.isNonBlank((CharSequence)data) && !unused) {
            return data.trim();
        }
        String file = config.get(fileKey);
        if (JavaGroovyEquivalents.groovyTruth((String)file)) {
            List<String> files = Arrays.asList(file.split(File.pathSeparator));
            List<String> filesTidied = LocationConfigUtils.tidyFilePaths(files);
            String fileData = LocationConfigUtils.getFileContents(filesTidied);
            if (fileData == null) {
                log.warn("Invalid file" + (files.size() > 1 ? "s" : "") + " for " + fileKey + " (given " + files + (files.equals(filesTidied) ? "" : "; converted to " + filesTidied) + ") may fail provisioning " + config.getDescription());
            } else if (JavaGroovyEquivalents.groovyTruth((String)data)) {
                if (!fileData.trim().equals(data.trim())) {
                    log.warn(dataKey.getName() + " and " + fileKey.getName() + " both specified; preferring the former");
                }
            } else {
                data = fileData;
                config.put(dataKey, data);
                config.get(dataKey);
            }
        }
        return data;
    }

    private static String getFileContents(Iterable<String> files) {
        Iterator<String> fi = files.iterator();
        while (fi.hasNext()) {
            String file = fi.next();
            if (!JavaGroovyEquivalents.groovyTruth((String)file)) continue;
            try {
                String result = ResourceUtils.create().getResourceAsString(file);
                if (result != null) {
                    return result;
                }
                log.debug("Invalid file " + file + " ; " + (!fi.hasNext() ? "no more files to try" : "trying next file") + " (null)");
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                log.debug("Invalid file " + file + " ; " + (!fi.hasNext() ? "no more files to try" : "trying next file"), (Throwable)e);
            }
        }
        return null;
    }

    private static List<String> tidyFilePaths(Iterable<String> files) {
        ArrayList result = Lists.newArrayList();
        for (String file : files) {
            result.add(Os.tidyPath((String)file));
        }
        return result;
    }

    public static Map<ConfigKey<String>, String> finalAndOriginalSpecs(String finalSpec, Object ... sourcesForOriginalSpec) {
        MutableMap result = MutableMap.of();
        if (finalSpec != null) {
            result.put(LocationInternal.FINAL_SPEC, finalSpec);
        }
        String originalSpec = null;
        for (Object source : sourcesForOriginalSpec) {
            if (source instanceof CharSequence) {
                originalSpec = source.toString();
            } else if (source instanceof Map) {
                if (originalSpec == null) {
                    originalSpec = Strings.toString(((Map)source).get(LocationInternal.ORIGINAL_SPEC));
                }
                if (originalSpec == null) {
                    originalSpec = Strings.toString(((Map)source).get(LocationInternal.ORIGINAL_SPEC.getName()));
                }
            }
            if (originalSpec != null) break;
        }
        if (originalSpec == null) {
            originalSpec = finalSpec;
        }
        if (originalSpec != null) {
            result.put(LocationInternal.ORIGINAL_SPEC, originalSpec);
        }
        return result;
    }

    public static boolean isResolverPrefixEnabled(ManagementContext mgmt, String resolverIdPrefix) {
        return LocationConfigUtils.isEnabled(mgmt, BROOKLYN_LOCATION_PREFIX + "." + resolverIdPrefix);
    }

    public static boolean isEnabled(ManagementContext mgmt, String key) {
        ConfigKey<Boolean> k = ConfigKeys.newConfigKeyWithPrefix(key + ".", LocationConfigKeys.ENABLED);
        Boolean enabled = (Boolean)mgmt.getConfig().getConfig(k);
        if (enabled != null) {
            return enabled;
        }
        return true;
    }

    @Beta
    public static class OsCredential {
        private final ConfigBag config;
        private boolean preferPassword = false;
        private boolean tryDefaultKeys = true;
        private boolean requirePublicKey = true;
        private boolean doKeyValidation = BrooklynFeatureEnablement.isEnabled("brooklyn.validate.locationSshKeys");
        private boolean warnOnErrors = true;
        private boolean throwOnErrors = false;
        private boolean dirty = true;
        private String privateKeyData;
        private String publicKeyData;
        private String password;
        Set<String> warningMessages = MutableSet.of();

        private OsCredential(ConfigBag config) {
            this.config = config;
        }

        public OsCredential checkNotEmpty() {
            this.checkNoErrors();
            if (!this.hasKey() && !this.hasPassword()) {
                if (this.warningMessages.size() > 0) {
                    throw new IllegalStateException("Could not find credentials: " + this.warningMessages);
                }
                throw new IllegalStateException("Could not find credentials");
            }
            return this;
        }

        public OsCredential checkNoErrors() {
            this.throwOnErrors(true);
            this.dirty();
            this.infer();
            return this;
        }

        public OsCredential logAnyWarnings() {
            if (!this.warningMessages.isEmpty()) {
                log.warn("When reading credentials: " + this.warningMessages);
            }
            return this;
        }

        public Set<String> getWarningMessages() {
            return this.warningMessages;
        }

        public synchronized String getPreferredCredential() {
            this.infer();
            if (this.isUsingPassword()) {
                return this.password;
            }
            if (this.hasKey()) {
                return this.privateKeyData;
            }
            return null;
        }

        public boolean isEmpty() {
            return !this.hasKey() && !this.hasPassword();
        }

        public boolean hasKey() {
            this.infer();
            return Strings.isNonBlank((CharSequence)this.privateKeyData);
        }

        public boolean hasPassword() {
            this.infer();
            return this.password != null;
        }

        public boolean isUsingPassword() {
            return this.hasPassword() && (!this.hasKey() || this.preferPassword);
        }

        public String getPrivateKeyData() {
            this.infer();
            return this.privateKeyData;
        }

        public String getPublicKeyData() {
            this.infer();
            return this.publicKeyData;
        }

        public String getPassword() {
            this.infer();
            return this.password;
        }

        public OsCredential preferKey() {
            this.preferPassword = false;
            return this.dirty();
        }

        public OsCredential preferPassword() {
            this.preferPassword = true;
            return this.dirty();
        }

        public OsCredential requirePublicKey(boolean requirePublicKey) {
            this.requirePublicKey = requirePublicKey;
            return this.dirty();
        }

        public OsCredential doKeyValidation(boolean doKeyValidation) {
            this.doKeyValidation = doKeyValidation;
            return this.dirty();
        }

        public OsCredential useDefaultKeys(boolean tryDefaultKeys) {
            this.tryDefaultKeys = tryDefaultKeys;
            return this.dirty();
        }

        public OsCredential warnOnErrors(boolean warnOnErrors) {
            this.warnOnErrors = warnOnErrors;
            return this.dirty();
        }

        public OsCredential throwOnErrors(boolean throwOnErrors) {
            this.throwOnErrors = throwOnErrors;
            return this.dirty();
        }

        private OsCredential dirty() {
            this.dirty = true;
            return this;
        }

        public static OsCredential newInstance(ConfigBag config) {
            return new OsCredential(config);
        }

        private synchronized void infer() {
            if (!this.dirty) {
                return;
            }
            this.warningMessages.clear();
            log.debug("Inferring OS credentials");
            this.privateKeyData = this.config.get(LocationConfigKeys.PRIVATE_KEY_DATA);
            this.password = this.config.get(LocationConfigKeys.PASSWORD);
            this.publicKeyData = LocationConfigUtils.getKeyDataFromDataKeyOrFileKey(this.config, (ConfigKey<String>)LocationConfigKeys.PUBLIC_KEY_DATA, (ConfigKey<String>)LocationConfigKeys.PUBLIC_KEY_FILE);
            KeyPair privateKey = null;
            if (Strings.isBlank((CharSequence)this.privateKeyData)) {
                String privateKeyFiles = null;
                boolean privateKeyFilesExplicitlySet = this.config.containsKey(LocationConfigKeys.PRIVATE_KEY_FILE);
                if (privateKeyFilesExplicitlySet || this.tryDefaultKeys && this.password == null) {
                    privateKeyFiles = this.config.get(LocationConfigKeys.PRIVATE_KEY_FILE);
                }
                if (Strings.isNonBlank(privateKeyFiles)) {
                    Iterator<String> fi = Arrays.asList(privateKeyFiles.split(File.pathSeparator)).iterator();
                    while (fi.hasNext()) {
                        String file = fi.next();
                        if (!Strings.isNonBlank((CharSequence)file)) continue;
                        try {
                            if (file != null) {
                                this.privateKeyData = ResourceUtils.create().getResourceAsString(file);
                            }
                            privateKey = this.getValidatedPrivateKey(file);
                            if (this.privateKeyData == null) continue;
                            if (Strings.isNonBlank((CharSequence)this.publicKeyData)) {
                                log.debug("Loaded private key data from " + file + " (public key data explicitly set)");
                                break;
                            }
                            String publicKeyFile = file != null ? file + ".pub" : "(data)";
                            try {
                                this.publicKeyData = ResourceUtils.create().getResourceAsString(publicKeyFile);
                                log.debug("Loaded private key data from " + file + " and public key data from " + publicKeyFile);
                                break;
                            }
                            catch (Exception e) {
                                Exceptions.propagateIfFatal((Throwable)e);
                                log.debug("No public key file " + publicKeyFile + "; will try extracting from private key");
                                this.publicKeyData = AuthorizedKeysParser.encodePublicKey((PublicKey)privateKey.getPublic());
                                if (this.publicKeyData == null) {
                                    if (!this.requirePublicKey) {
                                        log.debug("Loaded private key data from " + file + " (public key data not found but not required)");
                                        break;
                                    }
                                } else {
                                    log.debug("Loaded private key data from " + file + " (public key data extracted)");
                                    break;
                                }
                                this.addWarning("Unable to find or extract public key for " + file, "skipping");
                                this.privateKeyData = null;
                            }
                        }
                        catch (Exception e) {
                            Exceptions.propagateIfFatal((Throwable)e);
                            String message = "Missing/invalid private key file " + file;
                            if (!privateKeyFilesExplicitlySet) continue;
                            this.addWarning(message, (!fi.hasNext() ? "no more files to try" : "trying next file") + ": " + e);
                        }
                    }
                    if (privateKeyFilesExplicitlySet && Strings.isBlank((CharSequence)this.privateKeyData)) {
                        this.error("No valid private keys found", "" + this.warningMessages);
                    }
                }
            } else {
                privateKey = this.getValidatedPrivateKey("(data)");
            }
            if (this.privateKeyData != null) {
                if (this.requirePublicKey && Strings.isBlank((CharSequence)this.publicKeyData)) {
                    if (privateKey != null) {
                        this.publicKeyData = AuthorizedKeysParser.encodePublicKey((PublicKey)privateKey.getPublic());
                    }
                    if (Strings.isBlank((CharSequence)this.publicKeyData)) {
                        this.error("If explicit " + LocationConfigKeys.PRIVATE_KEY_DATA.getName() + " is supplied, then the corresponding " + LocationConfigKeys.PUBLIC_KEY_DATA.getName() + " must also be supplied.", null);
                    } else {
                        log.debug("Public key data extracted");
                    }
                }
                if (this.doKeyValidation && privateKey != null && privateKey.getPublic() != null && Strings.isNonBlank((CharSequence)this.publicKeyData)) {
                    PublicKey decoded = null;
                    try {
                        decoded = AuthorizedKeysParser.decodePublicKey((String)this.publicKeyData);
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        this.addWarning("Invalid public key: " + decoded);
                    }
                    if (decoded != null && !privateKey.getPublic().equals(decoded)) {
                        this.error("Public key inferred from does not match public key extracted from private key", null);
                    }
                }
            }
            log.debug("OS credential inference: " + this);
            this.dirty = false;
        }

        private KeyPair getValidatedPrivateKey(String label) {
            KeyPair privateKey;
            block7: {
                privateKey = null;
                String passphrase = this.config.get(CloudLocationConfig.PRIVATE_KEY_PASSPHRASE);
                try {
                    privateKey = SecureKeys.readPem(this.privateKeyData.getBytes(), passphrase);
                    if (passphrase != null) {
                        this.privateKeyData = SecureKeys.toPem(privateKey);
                    }
                }
                catch (SecureKeys.PassphraseProblem e) {
                    if (this.doKeyValidation) {
                        log.debug("Encountered error handling key " + label + ": " + e, (Throwable)e);
                        if (Strings.isBlank((CharSequence)passphrase)) {
                            this.addWarning("Passphrase required for key '" + label + "'");
                        } else {
                            this.addWarning("Invalid passphrase for key '" + label + "'");
                        }
                        this.privateKeyData = null;
                    }
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    if (!this.doKeyValidation) break block7;
                    this.addWarning("Unable to parse private key from '" + label + "': unknown format");
                    this.privateKeyData = null;
                }
            }
            return privateKey;
        }

        private void error(String msg, String logExtension) {
            this.addWarning(msg);
            if (this.warnOnErrors) {
                log.warn(msg + (logExtension == null ? "" : ": " + logExtension));
            }
            if (this.throwOnErrors) {
                throw new IllegalStateException(msg + (logExtension == null ? "" : "; " + logExtension));
            }
        }

        private void addWarning(String msg) {
            this.addWarning(msg, null);
        }

        private void addWarning(String msg, String debugExtension) {
            log.debug(msg + (debugExtension == null ? "" : "; " + debugExtension));
            this.warningMessages.add(msg);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + (Strings.isNonBlank((CharSequence)this.publicKeyData) ? this.publicKeyData : "no-public-key") + ";" + (Strings.isNonBlank((CharSequence)this.privateKeyData) ? "private-key-present" : "no-private-key") + "," + (this.password != null ? "password(len=" + this.password.length() + ")" : "no-password") + "]";
        }
    }
}

