/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointAddressBuilder;
import io.fabric8.kubernetes.api.model.EndpointAddressFluentImpl;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointPortBuilder;
import io.fabric8.kubernetes.api.model.EndpointPortFluentImpl;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.EndpointSubsetFluent;
import java.util.ArrayList;
import java.util.List;

public class EndpointSubsetFluentImpl<A extends EndpointSubsetFluent<A>>
extends BaseFluent<A>
implements EndpointSubsetFluent<A> {
    private List<VisitableBuilder<? extends EndpointAddress, ?>> addresses = new ArrayList();
    private List<VisitableBuilder<? extends EndpointAddress, ?>> notReadyAddresses = new ArrayList();
    private List<VisitableBuilder<? extends EndpointPort, ?>> ports = new ArrayList();

    public EndpointSubsetFluentImpl() {
    }

    public EndpointSubsetFluentImpl(EndpointSubset instance) {
        this.withAddresses(instance.getAddresses());
        this.withNotReadyAddresses(instance.getNotReadyAddresses());
        this.withPorts(instance.getPorts());
    }

    @Override
    public A addToAddresses(EndpointAddress ... items) {
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddresses(EndpointAddress ... items) {
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.remove(builder);
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<EndpointAddress> getAddresses() {
        return EndpointSubsetFluentImpl.build(this.addresses);
    }

    @Override
    public A withAddresses(List<EndpointAddress> addresses) {
        this._visitables.removeAll(this.addresses);
        this.addresses.clear();
        if (addresses != null) {
            for (EndpointAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withAddresses(EndpointAddress ... addresses) {
        this.addresses.clear();
        if (addresses != null) {
            for (EndpointAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public EndpointSubsetFluent.AddressesNested<A> addNewAddress() {
        return new AddressesNestedImpl();
    }

    @Override
    public EndpointSubsetFluent.AddressesNested<A> addNewAddressLike(EndpointAddress item) {
        return new AddressesNestedImpl(item);
    }

    @Override
    public A addToNotReadyAddresses(EndpointAddress ... items) {
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.add(builder);
            this.notReadyAddresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromNotReadyAddresses(EndpointAddress ... items) {
        for (EndpointAddress item : items) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.remove(builder);
            this.notReadyAddresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<EndpointAddress> getNotReadyAddresses() {
        return EndpointSubsetFluentImpl.build(this.notReadyAddresses);
    }

    @Override
    public A withNotReadyAddresses(List<EndpointAddress> notReadyAddresses) {
        this._visitables.removeAll(this.notReadyAddresses);
        this.notReadyAddresses.clear();
        if (notReadyAddresses != null) {
            for (EndpointAddress item : notReadyAddresses) {
                this.addToNotReadyAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withNotReadyAddresses(EndpointAddress ... notReadyAddresses) {
        this.notReadyAddresses.clear();
        if (notReadyAddresses != null) {
            for (EndpointAddress item : notReadyAddresses) {
                this.addToNotReadyAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddress() {
        return new NotReadyAddressesNestedImpl();
    }

    @Override
    public EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddressLike(EndpointAddress item) {
        return new NotReadyAddressesNestedImpl(item);
    }

    @Override
    public A addToPorts(EndpointPort ... items) {
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(EndpointPort ... items) {
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<EndpointPort> getPorts() {
        return EndpointSubsetFluentImpl.build(this.ports);
    }

    @Override
    public A withPorts(List<EndpointPort> ports) {
        this._visitables.removeAll(this.ports);
        this.ports.clear();
        if (ports != null) {
            for (EndpointPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withPorts(EndpointPort ... ports) {
        this.ports.clear();
        if (ports != null) {
            for (EndpointPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public EndpointSubsetFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public EndpointSubsetFluent.PortsNested<A> addNewPortLike(EndpointPort item) {
        return new PortsNestedImpl(item);
    }

    @Override
    public A addNewPort(String name, Integer port, String protocol) {
        return this.addToPorts(new EndpointPort(name, port, protocol));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointSubsetFluentImpl that = (EndpointSubsetFluentImpl)o;
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        if (this.notReadyAddresses != null ? !this.notReadyAddresses.equals(that.notReadyAddresses) : that.notReadyAddresses != null) {
            return false;
        }
        return !(this.ports != null ? !this.ports.equals(that.ports) : that.ports != null);
    }

    public class PortsNestedImpl<N>
    extends EndpointPortFluentImpl<EndpointSubsetFluent.PortsNested<N>>
    implements EndpointSubsetFluent.PortsNested<N>,
    Nested<N> {
        private final EndpointPortBuilder builder;

        PortsNestedImpl(EndpointPort item) {
            this.builder = new EndpointPortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.builder = new EndpointPortBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointSubsetFluentImpl.this.addToPorts(this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    public class NotReadyAddressesNestedImpl<N>
    extends EndpointAddressFluentImpl<EndpointSubsetFluent.NotReadyAddressesNested<N>>
    implements EndpointSubsetFluent.NotReadyAddressesNested<N>,
    Nested<N> {
        private final EndpointAddressBuilder builder;

        NotReadyAddressesNestedImpl(EndpointAddress item) {
            this.builder = new EndpointAddressBuilder(this, item);
        }

        NotReadyAddressesNestedImpl() {
            this.builder = new EndpointAddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointSubsetFluentImpl.this.addToNotReadyAddresses(this.builder.build());
        }

        @Override
        public N endNotReadyAddress() {
            return this.and();
        }
    }

    public class AddressesNestedImpl<N>
    extends EndpointAddressFluentImpl<EndpointSubsetFluent.AddressesNested<N>>
    implements EndpointSubsetFluent.AddressesNested<N>,
    Nested<N> {
        private final EndpointAddressBuilder builder;

        AddressesNestedImpl(EndpointAddress item) {
            this.builder = new EndpointAddressBuilder(this, item);
        }

        AddressesNestedImpl() {
            this.builder = new EndpointAddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointSubsetFluentImpl.this.addToAddresses(this.builder.build());
        }

        @Override
        public N endAddress() {
            return this.and();
        }
    }
}

