/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

public abstract class BookieException
extends Exception {
    private final int code;

    public BookieException(int code) {
        this.code = code;
    }

    public BookieException(int code, Throwable t) {
        super(t);
        this.code = code;
    }

    public BookieException(int code, String reason) {
        super(reason);
        this.code = code;
    }

    public BookieException(int code, String reason, Throwable t) {
        super(reason, t);
        this.code = code;
    }

    public static BookieException create(int code) {
        switch (code) {
            case -1: {
                return new BookieUnauthorizedAccessException();
            }
            case -101: {
                return new LedgerFencedException();
            }
            case -102: {
                return new InvalidCookieException();
            }
            case -103: {
                return new UpgradeException();
            }
            case -104: {
                return new DiskPartitionDuplicationException();
            }
            case -105: {
                return new CookieNotFoundException();
            }
            case -109: {
                return new CookieExistException();
            }
            case -106: {
                return new MetadataStoreException();
            }
            case -107: {
                return new UnknownBookieIdException();
            }
            case -111: {
                return new DataUnknownException();
            }
        }
        return new BookieIllegalOpException();
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage(int code) {
        String err;
        switch (code) {
            case 0: {
                err = "No problem";
                break;
            }
            case -1: {
                err = "Error while reading ledger";
                break;
            }
            case -101: {
                err = "Ledger has been fenced; No more entries can be added";
                break;
            }
            case -102: {
                err = "Invalid environment cookie found";
                break;
            }
            case -103: {
                err = "Error performing an upgrade operation ";
                break;
            }
            case -104: {
                err = "Disk Partition Duplication is not allowed";
                break;
            }
            case -105: {
                err = "Cookie not found";
                break;
            }
            case -109: {
                err = "Cookie already exists";
                break;
            }
            case -110: {
                err = "Error in accessing Entry-log metadata map";
                break;
            }
            case -106: {
                err = "Error performing metadata operations";
                break;
            }
            case -107: {
                err = "Unknown bookie id";
                break;
            }
            case -108: {
                err = "Operation rejected";
                break;
            }
            case -111: {
                err = "Unable to respond, ledger is in unknown state";
                break;
            }
            default: {
                err = "Invalid operation";
            }
        }
        String reason = super.getMessage();
        if (reason == null && super.getCause() != null) {
            reason = super.getCause().getMessage();
        }
        if (reason == null) {
            return err;
        }
        return String.format("%s [%s]", err, reason);
    }

    public static class DataUnknownException
    extends BookieException {
        public DataUnknownException() {
            super(-111);
        }

        public DataUnknownException(Throwable t) {
            super(-111, t);
        }

        public DataUnknownException(String reason) {
            super(-111, reason);
        }

        public DataUnknownException(String reason, Throwable t) {
            super(-111, reason, t);
        }
    }

    public static class UnknownBookieIdException
    extends BookieException {
        public UnknownBookieIdException() {
            super(-107);
        }

        public UnknownBookieIdException(Throwable cause) {
            super(-107, cause);
        }
    }

    public static class MetadataStoreException
    extends BookieException {
        public MetadataStoreException() {
            this("");
        }

        public MetadataStoreException(String reason) {
            super(-106, reason);
        }

        public MetadataStoreException(Throwable cause) {
            super(-106, cause);
        }

        public MetadataStoreException(String reason, Throwable cause) {
            super(-106, reason, cause);
        }
    }

    public static class DiskPartitionDuplicationException
    extends BookieException {
        public DiskPartitionDuplicationException() {
            super(-104);
        }

        public DiskPartitionDuplicationException(Throwable cause) {
            super(-104, cause);
        }

        public DiskPartitionDuplicationException(String reason) {
            super(-104, reason);
        }
    }

    public static class UpgradeException
    extends BookieException {
        public UpgradeException() {
            super(-103);
        }

        public UpgradeException(Throwable cause) {
            super(-103, cause);
        }

        public UpgradeException(String reason) {
            super(-103, reason);
        }
    }

    public static class EntryLogMetadataMapException
    extends BookieException {
        public EntryLogMetadataMapException(Throwable cause) {
            super(-110, cause);
        }
    }

    public static class CookieExistException
    extends BookieException {
        public CookieExistException() {
            this("");
        }

        public CookieExistException(String reason) {
            super(-109, reason);
        }

        public CookieExistException(Throwable cause) {
            super(-109, cause);
        }
    }

    public static class CookieNotFoundException
    extends BookieException {
        public CookieNotFoundException() {
            this("");
        }

        public CookieNotFoundException(String reason) {
            super(-105, reason);
        }

        public CookieNotFoundException(Throwable cause) {
            super(-105, cause);
        }
    }

    public static class InvalidCookieException
    extends BookieException {
        public InvalidCookieException() {
            this("");
        }

        public InvalidCookieException(String reason) {
            super(-102, reason);
        }

        public InvalidCookieException(Throwable cause) {
            super(-102, cause);
        }
    }

    public static class OperationRejectedException
    extends BookieException {
        public OperationRejectedException() {
            super(-108);
        }

        @Override
        public Throwable fillInStackTrace() {
            return null;
        }
    }

    public static class LedgerFencedException
    extends BookieException {
        public LedgerFencedException() {
            super(-101);
        }
    }

    public static class BookieIllegalOpException
    extends BookieException {
        public BookieIllegalOpException() {
            super(-100);
        }

        public BookieIllegalOpException(String reason) {
            super(-100, reason);
        }

        public BookieIllegalOpException(Throwable cause) {
            super(-100, cause);
        }
    }

    public static class BookieUnauthorizedAccessException
    extends BookieException {
        public BookieUnauthorizedAccessException() {
            super(-1);
        }

        public BookieUnauthorizedAccessException(String reason) {
            super(-1, reason);
        }
    }

    public static interface Code {
        public static final int OK = 0;
        public static final int UnauthorizedAccessException = -1;
        public static final int IllegalOpException = -100;
        public static final int LedgerFencedException = -101;
        public static final int InvalidCookieException = -102;
        public static final int UpgradeException = -103;
        public static final int DiskPartitionDuplicationException = -104;
        public static final int CookieNotFoundException = -105;
        public static final int MetadataStoreException = -106;
        public static final int UnknownBookieIdException = -107;
        public static final int OperationRejectedException = -108;
        public static final int CookieExistsException = -109;
        public static final int EntryLogMetadataMapException = -110;
        public static final int DataUnknownException = -111;
    }
}

