/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.source;

import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import org.inferred.freebuilder.processor.model.ModelUtils;
import org.inferred.freebuilder.processor.source.QualifiedName;
import org.inferred.freebuilder.processor.source.Quotes;
import org.inferred.freebuilder.processor.source.SourceBuilder;
import org.inferred.freebuilder.shaded.com.google.common.collect.Iterables;

public class AnnotationSource {
    public static void addSource(SourceBuilder code, AnnotationMirror annotation) {
        new ValueSourceAdder(code).visitAnnotation(annotation, null);
    }

    private static boolean hasSingleValueWithDefaultKey(AnnotationMirror annotation) {
        if (annotation.getElementValues().size() != 1) {
            return false;
        }
        ExecutableElement key = Iterables.getOnlyElement(annotation.getElementValues().keySet());
        return key.getSimpleName().contentEquals("value");
    }

    private AnnotationSource() {
    }

    private static class ValueSourceAdder
    extends SimpleAnnotationValueVisitor8<Void, AnnotationValue> {
        private final SourceBuilder code;

        ValueSourceAdder(SourceBuilder code) {
            this.code = code;
        }

        @Override
        public Void visitAnnotation(AnnotationMirror annotation, AnnotationValue unused) {
            this.code.add("@%s", QualifiedName.of(ModelUtils.asElement(annotation.getAnnotationType())));
            if (annotation.getElementValues().isEmpty()) {
                return null;
            }
            this.code.add("(", new Object[0]);
            if (AnnotationSource.hasSingleValueWithDefaultKey(annotation)) {
                AnnotationValue value = Iterables.getOnlyElement(annotation.getElementValues().values());
                this.visit(value, value);
            } else {
                String separator = "";
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotation.getElementValues().entrySet()) {
                    this.code.add("%s%s = ", separator, entry.getKey().getSimpleName());
                    this.visit(entry.getValue(), entry.getValue());
                    separator = ", ";
                }
            }
            this.code.add(")", new Object[0]);
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> vals, AnnotationValue unused) {
            if (vals.size() == 1) {
                AnnotationValue value = Iterables.getOnlyElement(vals);
                this.visit(value, value);
            } else {
                this.code.add("{", new Object[0]);
                String separator = "";
                for (AnnotationValue annotationValue : vals) {
                    this.code.add(separator, new Object[0]);
                    this.visit(annotationValue, annotationValue);
                    separator = ", ";
                }
                this.code.add("}", new Object[0]);
            }
            return null;
        }

        @Override
        public Void visitString(String s, AnnotationValue p) {
            this.code.add("\"%s\"", Quotes.escapeJava(s));
            return null;
        }

        @Override
        protected Void defaultAction(Object obj, AnnotationValue value) {
            this.code.add("%s", value.toString());
            return null;
        }

        @Override
        public Void visitUnknown(AnnotationValue value, AnnotationValue unused) {
            this.code.add("%s", value.toString());
            return null;
        }
    }
}

