/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.embedded;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.server.embedded.ExitHandler;
import org.apache.zookeeper.server.embedded.ZooKeeperServerEmbedded;
import org.apache.zookeeper.server.embedded.ZookeeperServeInfo;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class ZookeeperServerEmbeddedTest {
    @TempDir
    public Path baseDir;

    @BeforeAll
    public static void setUpEnvironment() {
        System.setProperty("zookeeper.admin.enableServer", "false");
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
    }

    @AfterAll
    public static void cleanUpEnvironment() throws InterruptedException, IOException {
        System.clearProperty("zookeeper.admin.enableServer");
        System.clearProperty("zookeeper.4lw.commands.whitelist");
    }

    @Test
    public void testStart() throws Exception {
        ZookeeperServeInfo.ServerInfo status;
        int clientPort = PortAssignment.unique();
        Properties configZookeeper = new Properties();
        configZookeeper.put("clientPort", clientPort + "");
        configZookeeper.put("host", "localhost");
        configZookeeper.put("ticktime", "4000");
        try (ZooKeeperServerEmbedded zkServer = ZooKeeperServerEmbedded.builder().baseDir(this.baseDir).configuration(configZookeeper).exitHandler(ExitHandler.LOG_ONLY).build();){
            zkServer.start();
            Assert.assertTrue((boolean)ClientBase.waitForServerUp(zkServer.getConnectionString(), 60000L));
            for (int i = 0; !(i >= 100 || (status = ZookeeperServeInfo.getStatus("StandaloneServer*")).isLeader() && status.isStandaloneMode()); ++i) {
                Thread.sleep(100L);
            }
            ZookeeperServeInfo.ServerInfo status2 = ZookeeperServeInfo.getStatus("StandaloneServer*");
            Assert.assertTrue((boolean)status2.isLeader());
            Assert.assertTrue((boolean)status2.isStandaloneMode());
        }
        zkServer = ZooKeeperServerEmbedded.builder().baseDir(this.baseDir).configuration(configZookeeper).exitHandler(ExitHandler.LOG_ONLY).build();
        var4_4 = null;
        try {
            zkServer.start();
            Assert.assertTrue((boolean)ClientBase.waitForServerUp(zkServer.getConnectionString(), 60000L));
            for (int i = 0; !(i >= 100 || (status = ZookeeperServeInfo.getStatus("StandaloneServer*")).isLeader() && status.isStandaloneMode()); ++i) {
                Thread.sleep(100L);
            }
            ZookeeperServeInfo.ServerInfo status3 = ZookeeperServeInfo.getStatus("StandaloneServer*");
            Assert.assertTrue((boolean)status3.isLeader());
            Assert.assertTrue((boolean)status3.isStandaloneMode());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (zkServer != null) {
                if (var4_4 != null) {
                    try {
                        zkServer.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    zkServer.close();
                }
            }
        }
    }
}

